/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.impl.HistoricCaseInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class DeleteHistoricCaseInstancesBulkCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<String> caseInstanceIds;

    public DeleteHistoricCaseInstancesBulkCmd(List<String> caseInstanceIds) {
        this.caseInstanceIds = caseInstanceIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "caseInstanceIds", this.caseInstanceIds);
        commandContext.runWithoutAuthorization(() -> {
            EnsureUtil.ensureEquals(BadUserRequestException.class, "ClosedCaseInstanceIds", new HistoricCaseInstanceQueryImpl().closed().caseInstanceIds(new HashSet<String>(this.caseInstanceIds)).count(), this.caseInstanceIds.size());
            return null;
        });
        commandContext.getOperationLogManager().logCaseInstanceOperation("DeleteHistory", null, null, Collections.singletonList(new PropertyChange("nrOfInstances", null, this.caseInstanceIds.size())));
        commandContext.getHistoricCaseInstanceManager().deleteHistoricCaseInstancesByIds(this.caseInstanceIds);
        return null;
    }
}

