/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.history.HistoricProcessInstance;
import io.openbpm.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeleteHistoricProcessInstancesCmd
implements Command<Void>,
Serializable {
    protected final List<String> processInstanceIds;
    protected final boolean failIfNotExists;

    public DeleteHistoricProcessInstancesCmd(List<String> processInstanceIds, boolean failIfNotExists) {
        this.processInstanceIds = processInstanceIds;
        this.failIfNotExists = failIfNotExists;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceIds", this.processInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "processInstanceId is null", "processInstanceIds", this.processInstanceIds);
        List instances = commandContext.runWithoutAuthorization(() -> new HistoricProcessInstanceQueryImpl().processInstanceIds(new HashSet<String>(this.processInstanceIds)).list());
        if (this.failIfNotExists) {
            if (this.processInstanceIds.size() == 1) {
                EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "No historic process instance found with id: " + this.processInstanceIds.get(0), "historicProcessInstanceIds", instances);
            } else {
                EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "No historic process instances found", "historicProcessInstanceIds", instances);
            }
        }
        ArrayList<String> existingIds = new ArrayList<String>();
        for (HistoricProcessInstance historicProcessInstance : instances) {
            existingIds.add(historicProcessInstance.getId());
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkDeleteHistoricProcessInstance(historicProcessInstance);
            }
            EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process instance is still running, cannot delete historic process instance: " + String.valueOf(historicProcessInstance), "instance.getEndTime()", (Object)historicProcessInstance.getEndTime());
        }
        if (this.failIfNotExists) {
            ArrayList<String> nonExistingIds = new ArrayList<String>(this.processInstanceIds);
            nonExistingIds.removeAll(existingIds);
            if (!nonExistingIds.isEmpty()) {
                throw new BadUserRequestException("No historic process instance found with id: " + String.valueOf(nonExistingIds));
            }
        }
        if (!existingIds.isEmpty()) {
            commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByIds(existingIds);
        }
        this.writeUserOperationLog(commandContext, existingIds.size());
        return null;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, false));
        commandContext.getOperationLogManager().logProcessInstanceOperation("DeleteHistory", null, null, null, propertyChanges);
    }
}

