/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;
import java.util.Arrays;

public class DeleteHistoricVariableInstancesByProcessInstanceIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String processInstanceId;

    public DeleteHistoricVariableInstancesByProcessInstanceIdCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceId", this.processInstanceId);
        HistoricProcessInstanceEntity instance = commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstance(this.processInstanceId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "No historic process instance found with id: " + this.processInstanceId, "instance", (Object)instance);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteHistoricVariableInstancesByProcessInstance(instance);
        }
        commandContext.getHistoricDetailManager().deleteHistoricDetailsByProcessInstanceIds(Arrays.asList(this.processInstanceId));
        commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstanceByProcessInstanceIds(Arrays.asList(this.processInstanceId));
        ProcessDefinitionEntity definition = null;
        try {
            definition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(instance.getProcessDefinitionId());
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        commandContext.getOperationLogManager().logHistoricVariableOperation("DeleteHistory", instance, definition, PropertyChange.EMPTY_CHANGE);
        return null;
    }
}

