/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import java.util.ArrayList;
import java.util.List;

public class DeleteJobsCmd
implements Command<Void> {
    protected List<String> jobIds;
    protected boolean cascade;

    public DeleteJobsCmd(List<String> jobIds) {
        this(jobIds, false);
    }

    public DeleteJobsCmd(List<String> jobIds, boolean cascade) {
        this.jobIds = jobIds;
        this.cascade = cascade;
    }

    public DeleteJobsCmd(String jobId) {
        this(jobId, false);
    }

    public DeleteJobsCmd(String jobId, boolean cascade) {
        this.jobIds = new ArrayList<String>();
        this.jobIds.add(jobId);
        this.cascade = cascade;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        JobEntity jobToDelete = null;
        for (String jobId : this.jobIds) {
            jobToDelete = Context.getCommandContext().getJobManager().findJobById(jobId);
            if (jobToDelete == null) continue;
            jobToDelete.delete();
            if (!this.cascade) continue;
            commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
        }
        return null;
    }
}

