/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskManager;
import java.io.Serializable;
import java.util.Collection;

public class DeleteTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Collection<String> taskIds;
    protected boolean cascade;
    protected String deleteReason;

    public DeleteTaskCmd(String taskId, String deleteReason, boolean cascade) {
        this.taskId = taskId;
        this.cascade = cascade;
        this.deleteReason = deleteReason;
    }

    public DeleteTaskCmd(Collection<String> taskIds, String deleteReason, boolean cascade) {
        this.taskIds = taskIds;
        this.cascade = cascade;
        this.deleteReason = deleteReason;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId != null) {
            this.deleteTask(this.taskId, commandContext);
        } else if (this.taskIds != null) {
            this.taskIds.forEach(id -> this.deleteTask((String)id, commandContext));
        } else {
            throw new ProcessEngineException("taskId and taskIds are null");
        }
        return null;
    }

    protected void deleteTask(String taskId, CommandContext commandContext) {
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(taskId);
        if (task != null) {
            if (task.getExecutionId() != null) {
                throw new ProcessEngineException("The task cannot be deleted because is part of a running process");
            }
            if (task.getCaseExecutionId() != null) {
                throw new ProcessEngineException("The task cannot be deleted because is part of a running case instance");
            }
            this.checkDeleteTask(task, commandContext);
            task.logUserOperation("Delete");
            String reason = this.deleteReason == null || this.deleteReason.isEmpty() ? "deleted" : this.deleteReason;
            task.delete(reason, this.cascade);
        } else if (this.cascade) {
            Context.getCommandContext().getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(taskId);
        }
    }

    protected void checkDeleteTask(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteTask(task);
        }
    }
}

