/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.CommentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.task.Comment;
import java.io.Serializable;
import java.util.List;

public class DeleteTaskCommentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String commentId;
    protected String taskId;

    public DeleteTaskCommentCmd(String taskId, String commentId) {
        this.taskId = taskId;
        this.commentId = commentId;
    }

    public DeleteTaskCommentCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "taskId", (Object)this.taskId);
        TaskEntity task = commandContext.getTaskManager().findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("No task exists with taskId: " + this.taskId, "task", (Object)task);
        this.checkTaskWork(task, commandContext);
        if (this.commentId != null) {
            CommentEntity comment = commandContext.getCommentManager().findCommentByTaskIdAndCommentId(this.taskId, this.commentId);
            if (comment != null) {
                commandContext.getDbEntityManager().delete(comment);
            }
        } else {
            List<Comment> comments = commandContext.getCommentManager().findCommentsByTaskId(this.taskId);
            if (!comments.isEmpty()) {
                commandContext.getCommentManager().deleteCommentsByTaskId(this.taskId);
            }
        }
        commandContext.getOperationLogManager().logCommentOperation("DeleteComment", task, new PropertyChange("comment", null, null));
        task.triggerUpdateEvent();
        return null;
    }

    protected void checkTaskWork(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkTaskWork(task);
        }
    }
}

