/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

public class DeleteTaskMetricsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Date timestamp;

    public DeleteTaskMetricsCmd(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkDeleteTaskMetrics);
        this.writeUserOperationLog(commandContext);
        commandContext.getMeterLogManager().deleteTaskMetricsByTimestamp(this.timestamp);
        return null;
    }

    protected void writeUserOperationLog(CommandContext commandContext) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        if (this.timestamp != null) {
            propertyChanges.add(new PropertyChange("timestamp", null, this.timestamp));
        }
        if (propertyChanges.isEmpty()) {
            propertyChanges.add(PropertyChange.EMPTY_CHANGE);
        }
        commandContext.getOperationLogManager().logTaskMetricsOperation("Delete", propertyChanges);
    }
}

