/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.IdentityService;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutorContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import io.openbpm.bpm.engine.impl.jobexecutor.JobFailureCollector;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;
import java.util.Collections;

public class ExecuteJobsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected String jobId;
    protected JobFailureCollector jobFailureCollector;

    public ExecuteJobsCmd(String jobId, JobFailureCollector jobFailureCollector) {
        this.jobId = jobId;
        this.jobFailureCollector = jobFailureCollector;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("jobId", (Object)this.jobId);
        JobEntity job = commandContext.getDbEntityManager().selectById(JobEntity.class, this.jobId);
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        IdentityService identityService = processEngineConfiguration.getIdentityService();
        JobExecutorContext jobExecutorContext = Context.getJobExecutorContext();
        if (job == null) {
            if (jobExecutorContext != null) {
                LOG.debugAcquiredJobNotFound(this.jobId);
                return null;
            }
            throw LOG.jobNotFoundException(this.jobId);
        }
        this.jobFailureCollector.setJob(job);
        if (jobExecutorContext == null) {
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkUpdateJob(job);
            }
            commandContext.getOperationLogManager().logJobOperation("Execute", this.jobId, job.getJobDefinitionId(), job.getProcessInstanceId(), job.getProcessDefinitionId(), job.getProcessDefinitionKey(), PropertyChange.EMPTY_CHANGE);
        } else {
            jobExecutorContext.setCurrentJob(job);
            String tenantId = job.getTenantId();
            if (tenantId != null) {
                identityService.setAuthentication(null, null, Collections.singletonList(tenantId));
            }
        }
        try {
            commandContext.registerCommandContextListener(this.jobFailureCollector);
            commandContext.setCurrentJob(job);
            job.execute(commandContext);
        }
        catch (Throwable t) {
            String failedActivityId = Context.getCommandInvocationContext().getProcessDataContext().getLatestActivityId();
            this.jobFailureCollector.setFailedActivityId(failedActivityId);
            throw t;
        }
        finally {
            if (jobExecutorContext != null) {
                jobExecutorContext.setCurrentJob(null);
                identityService.clearAuthentication();
            }
        }
        return null;
    }
}

