/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.Collections;
import java.util.List;

public abstract class ExternalTaskCmd
implements Command<Void> {
    protected String externalTaskId;

    protected ExternalTaskCmd(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("externalTaskId", (Object)this.externalTaskId);
        this.validateInput();
        ExternalTaskEntity externalTask = commandContext.getExternalTaskManager().findExternalTaskById(this.externalTaskId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Cannot find external task with id " + this.externalTaskId, "externalTask", (Object)externalTask);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstanceById(externalTask.getProcessInstanceId());
        }
        this.writeUserOperationLog(commandContext, externalTask, this.getUserOperationLogOperationType(), this.getUserOperationLogPropertyChanges(externalTask));
        this.execute(externalTask);
        return null;
    }

    protected void writeUserOperationLog(CommandContext commandContext, ExternalTaskEntity externalTask, String operationType, List<PropertyChange> propertyChanges) {
        if (operationType != null) {
            commandContext.getOperationLogManager().logExternalTaskOperation(operationType, externalTask, propertyChanges == null || propertyChanges.isEmpty() ? Collections.singletonList(PropertyChange.EMPTY_CHANGE) : propertyChanges);
        }
    }

    protected String getUserOperationLogOperationType() {
        return null;
    }

    protected List<PropertyChange> getUserOperationLogPropertyChanges(ExternalTaskEntity externalTask) {
        return Collections.emptyList();
    }

    protected abstract void execute(ExternalTaskEntity var1);

    protected abstract void validateInput();
}

