/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.bpmn.diagram.ProcessDiagramLayoutFactory;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentProcessDiagramCmd;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentProcessModelCmd;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.repository.DiagramLayout;
import java.io.InputStream;
import java.io.Serializable;

public class GetDeploymentProcessDiagramLayoutCmd
implements Command<DiagramLayout>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetDeploymentProcessDiagramLayoutCmd(String processDefinitionId) {
        if (processDefinitionId == null || processDefinitionId.isEmpty()) {
            throw new ProcessEngineException("The process definition id is mandatory, but '" + processDefinitionId + "' has been provided.");
        }
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public DiagramLayout execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessDefinition(processDefinition);
        }
        InputStream processModelStream = commandContext.runWithoutAuthorization(new GetDeploymentProcessModelCmd(this.processDefinitionId));
        InputStream processDiagramStream = commandContext.runWithoutAuthorization(new GetDeploymentProcessDiagramCmd(this.processDefinitionId));
        return new ProcessDiagramLayoutFactory().getProcessDiagramLayout(processModelStream, processDiagramStream);
    }
}

