/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.form.OperatonFormRef;
import io.openbpm.bpm.engine.impl.form.entity.OperatonFormDefinitionManager;
import io.openbpm.bpm.engine.impl.form.handler.DefaultFormHandler;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.OperatonFormDefinitionEntity;
import io.openbpm.bpm.engine.repository.OperatonFormDefinition;

public class GetOperatonFormDefinitionCmd
implements Command<OperatonFormDefinition> {
    protected OperatonFormRef operatonFormRef;
    protected String deploymentId;

    public GetOperatonFormDefinitionCmd(OperatonFormRef operatonFormRef, String deploymentId) {
        this.operatonFormRef = operatonFormRef;
        this.deploymentId = deploymentId;
    }

    @Override
    public OperatonFormDefinition execute(CommandContext commandContext) {
        String binding = this.operatonFormRef.getBinding();
        String key = this.operatonFormRef.getKey();
        OperatonFormDefinitionEntity definition = null;
        OperatonFormDefinitionManager manager = commandContext.getOperatonFormDefinitionManager();
        if ("deployment".equals(binding)) {
            definition = manager.findDefinitionByDeploymentAndKey(this.deploymentId, key);
        } else if ("latest".equals(binding)) {
            definition = manager.findLatestDefinitionByKey(key);
        } else if ("version".equals(binding)) {
            definition = manager.findDefinitionByKeyVersionAndTenantId(key, this.operatonFormRef.getVersion(), null);
        } else {
            throw new BadUserRequestException("Unsupported binding type for operatonFormRef. Expected to be one of " + String.valueOf(DefaultFormHandler.ALLOWED_FORM_REF_BINDINGS) + " but was:" + binding);
        }
        return definition;
    }
}

