/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.ScriptEvaluationException;
import io.openbpm.bpm.engine.form.StartFormData;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.form.engine.FormEngine;
import io.openbpm.bpm.engine.impl.form.handler.StartFormHandler;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class GetRenderedStartFormCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String formEngineName;
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;

    public GetRenderedStartFormCmd(String processDefinitionId, String formEngineName) {
        this.processDefinitionId = processDefinitionId;
        this.formEngineName = formEngineName;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
        EnsureUtil.ensureNotNull("Process Definition '" + this.processDefinitionId + "' not found", "processDefinition", (Object)processDefinition);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessDefinition(processDefinition);
        }
        StartFormHandler startFormHandler = processDefinition.getStartFormHandler();
        if (startFormHandler == null) {
            return null;
        }
        FormEngine formEngine = Context.getProcessEngineConfiguration().getFormEngines().get(this.formEngineName);
        EnsureUtil.ensureNotNull("No formEngine '" + this.formEngineName + "' defined process engine configuration", "formEngine", (Object)formEngine);
        StartFormData startForm = startFormHandler.createStartFormData(processDefinition);
        Object renderedStartForm = null;
        try {
            renderedStartForm = formEngine.renderStartForm(startForm);
        }
        catch (ScriptEvaluationException e) {
            LOG.exceptionWhenStartFormScriptEvaluation(this.processDefinitionId, e);
        }
        return renderedStartForm;
    }
}

