/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.form.TaskFormData;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.form.engine.FormEngine;
import io.openbpm.bpm.engine.impl.form.handler.TaskFormHandler;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskManager;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class GetRenderedTaskFormCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String formEngineName;

    public GetRenderedTaskFormCmd(String taskId, String formEngineName) {
        this.taskId = taskId;
        this.formEngineName = formEngineName;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("Task '" + this.taskId + "' not found", "task", (Object)task);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadTaskVariable(task);
        }
        EnsureUtil.ensureNotNull("Task form definition for '" + this.taskId + "' not found", "task.getTaskDefinition()", (Object)task.getTaskDefinition());
        TaskFormHandler taskFormHandler = task.getTaskDefinition().getTaskFormHandler();
        if (taskFormHandler == null) {
            return null;
        }
        FormEngine formEngine = Context.getProcessEngineConfiguration().getFormEngines().get(this.formEngineName);
        EnsureUtil.ensureNotNull("No formEngine '" + this.formEngineName + "' defined process engine configuration", "formEngine", (Object)formEngine);
        TaskFormData taskForm = taskFormHandler.createTaskForm(task);
        return formEngine.renderTaskForm(taskForm);
    }
}

