/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.AuthorizationException;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.CallActivityBehavior;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cmd.GetDeployedProcessDefinitionCmd;
import io.openbpm.bpm.engine.impl.core.model.CallableElement;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.repository.CalledProcessDefinitionImpl;
import io.openbpm.bpm.engine.impl.util.CallableElementUtil;
import io.openbpm.bpm.engine.repository.CalledProcessDefinition;
import io.openbpm.bpm.engine.repository.ProcessDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class GetStaticCalledProcessDefinitionCmd
implements Command<Collection<CalledProcessDefinition>> {
    protected String processDefinitionId;

    public GetStaticCalledProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    protected List<ActivityImpl> findCallActivitiesInProcess(ProcessDefinitionEntity processDefinition) {
        ArrayList<ActivityImpl> callActivities = new ArrayList<ActivityImpl>();
        LinkedList<ActivityImpl> toCheck = new LinkedList<ActivityImpl>(processDefinition.getActivities());
        while (!toCheck.isEmpty()) {
            ActivityImpl candidate = (ActivityImpl)toCheck.poll();
            if (!candidate.getActivities().isEmpty()) {
                toCheck.addAll(candidate.getActivities());
            }
            if (!(candidate.getActivityBehavior() instanceof CallActivityBehavior)) continue;
            callActivities.add(candidate);
        }
        return callActivities;
    }

    @Override
    public Collection<CalledProcessDefinition> execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = new GetDeployedProcessDefinitionCmd(this.processDefinitionId, true).execute(commandContext);
        List<ActivityImpl> callActivities = this.findCallActivitiesInProcess(processDefinition);
        HashMap<String, CalledProcessDefinitionImpl> calledProcessDefinitionsById = new HashMap<String, CalledProcessDefinitionImpl>();
        for (ActivityImpl activity : callActivities) {
            String tenantId;
            CallActivityBehavior behavior = (CallActivityBehavior)activity.getActivityBehavior();
            CallableElement callableElement = behavior.getCallableElement();
            String activityId = activity.getActivityId();
            ProcessDefinition calledProcess = CallableElementUtil.getStaticallyBoundProcessDefinition(this.processDefinitionId, activityId, callableElement, tenantId = processDefinition.getTenantId());
            if (calledProcess == null) continue;
            if (!calledProcessDefinitionsById.containsKey(calledProcess.getId())) {
                try {
                    for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                        checker.checkReadProcessDefinition(calledProcess);
                    }
                    CalledProcessDefinitionImpl result = new CalledProcessDefinitionImpl(calledProcess, this.processDefinitionId);
                    result.addCallingCallActivity(activityId);
                    calledProcessDefinitionsById.put(calledProcess.getId(), result);
                }
                catch (AuthorizationException e) {
                    ProcessEngineLogger.CMD_LOGGER.debugNotAllowedToResolveCalledProcess(calledProcess.getId(), this.processDefinitionId, activityId, e);
                }
                continue;
            }
            ((CalledProcessDefinitionImpl)calledProcessDefinitionsById.get(calledProcess.getId())).addCallingCallActivity(activityId);
        }
        return new ArrayList<CalledProcessDefinition>(calledProcessDefinitionsById.values());
    }
}

