/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.form.TaskFormData;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.form.handler.TaskFormHandler;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskManager;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class GetTaskFormCmd
implements Command<TaskFormData>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetTaskFormCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public TaskFormData execute(CommandContext commandContext) {
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("No task found for taskId '" + this.taskId + "'", "task", (Object)task);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadTaskVariable(task);
        }
        if (task.getTaskDefinition() != null) {
            TaskFormHandler taskFormHandler = task.getTaskDefinition().getTaskFormHandler();
            EnsureUtil.ensureNotNull("No taskFormHandler specified for task '" + this.taskId + "'", "taskFormHandler", (Object)taskFormHandler);
            return taskFormHandler.createTaskForm(task);
        }
        return null;
    }
}

