/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.authorization.BatchPermissions;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.impl.ModificationBatchConfiguration;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import io.openbpm.bpm.engine.impl.batch.BatchConfiguration;
import io.openbpm.bpm.engine.impl.batch.DeploymentMapping;
import io.openbpm.bpm.engine.impl.batch.DeploymentMappings;
import io.openbpm.bpm.engine.impl.batch.builder.BatchBuilder;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionManager;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import java.util.Collections;

public class ModifyProcessInstanceAsyncCmd
implements Command<Batch> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected ProcessInstanceModificationBuilderImpl builder;

    public ModifyProcessInstanceAsyncCmd(ProcessInstanceModificationBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        String processInstanceId = this.builder.getProcessInstanceId();
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity processInstance = executionManager.findExecutionById(processInstanceId);
        this.ensureProcessInstanceExists(processInstanceId, processInstance);
        String processDefinitionId = processInstance.getProcessDefinitionId();
        String tenantId = processInstance.getTenantId();
        String deploymentId = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId).getDeploymentId();
        return new BatchBuilder(commandContext).type("instance-modification").config(this.getConfiguration(processDefinitionId, deploymentId)).tenantId(tenantId).totalJobs(1).permission(BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES).operationLogHandler(this::writeOperationLog).build();
    }

    protected void ensureProcessInstanceExists(String processInstanceId, ExecutionEntity processInstance) {
        if (processInstance == null) {
            throw LOG.processInstanceDoesNotExist(processInstanceId);
        }
    }

    protected String getLogEntryOperation() {
        return "ModifyProcessInstance";
    }

    protected void writeOperationLog(CommandContext commandContext) {
        commandContext.getOperationLogManager().logProcessInstanceOperation(this.getLogEntryOperation(), this.builder.getProcessInstanceId(), null, null, Collections.singletonList(PropertyChange.EMPTY_CHANGE), this.builder.getAnnotation());
    }

    public BatchConfiguration getConfiguration(String processDefinitionId, String deploymentId) {
        return new ModificationBatchConfiguration(Collections.singletonList(this.builder.getProcessInstanceId()), DeploymentMappings.of(new DeploymentMapping(deploymentId, 1)), processDefinitionId, this.builder.getModificationOperations(), this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings());
    }
}

