/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cmd.AbstractRemoveVariableCmd;
import io.openbpm.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.Collection;

public class RemoveTaskVariablesCmd
extends AbstractRemoveVariableCmd {
    private static final long serialVersionUID = 1L;

    public RemoveTaskVariablesCmd(String taskId, Collection<String> variableNames, boolean isLocal) {
        super(taskId, variableNames, isLocal);
    }

    @Override
    protected TaskEntity getEntity() {
        EnsureUtil.ensureNotNull("taskId", (Object)this.entityId);
        TaskEntity task = this.commandContext.getTaskManager().findTaskById(this.entityId);
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.entityId, "task", (Object)task);
        this.checkRemoveTaskVariables(task);
        return task;
    }

    @Override
    protected ExecutionEntity getContextExecution() {
        return this.getEntity().getExecution();
    }

    @Override
    protected void logVariableOperation(AbstractVariableScope scope) {
        TaskEntity task = (TaskEntity)scope;
        this.commandContext.getOperationLogManager().logVariableOperation(this.getLogEntryOperation(), null, task.getId(), PropertyChange.EMPTY_CHANGE);
    }

    protected void checkRemoveTaskVariables(TaskEntity task) {
        for (CommandChecker checker : this.commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateTaskVariable(task);
        }
    }
}

