/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.exception.NotAllowedException;
import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.exception.NullValueException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.task.Task;
import java.io.Serializable;

public class SaveTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TaskEntity task;

    public SaveTaskCmd(Task task) {
        this.task = (TaskEntity)task;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        String operation;
        EnsureUtil.ensureNotNull("task", (Object)this.task);
        this.validateStandaloneTask(this.task, commandContext);
        if (this.task.getRevision() == 0) {
            try {
                this.checkCreateTask(this.task, commandContext);
                this.task.ensureParentTaskActive();
                this.task.propagateParentTaskTenantId();
                this.task.insert();
                operation = "Create";
                this.task.executeMetrics("activity-instance-start", commandContext);
            }
            catch (NullValueException e) {
                throw new NotValidException(e.getMessage(), e);
            }
            this.task.fireAuthorizationProvider();
            this.task.transitionTo(TaskEntity.TaskState.STATE_CREATED);
        } else {
            this.checkTaskAssign(this.task, commandContext);
            this.task.update();
            operation = "Update";
            this.task.fireAuthorizationProvider();
            this.task.triggerUpdateEvent();
        }
        this.task.executeMetrics("unique-task-workers", commandContext);
        this.task.logUserOperation(operation);
        return null;
    }

    protected void validateStandaloneTask(TaskEntity task, CommandContext commandContext) {
        boolean standaloneTasksEnabled = commandContext.getProcessEngineConfiguration().isStandaloneTasksEnabled();
        if (!standaloneTasksEnabled && task.isStandaloneTask()) {
            throw new NotAllowedException("Cannot save standalone task. They are disabled in the process engine configuration.");
        }
    }

    protected void checkTaskAssign(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkTaskAssign(task);
        }
    }

    protected void checkCreateTask(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateTask(task);
        }
    }
}

