/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.history.event.HistoricIncidentEventEntity;
import io.openbpm.bpm.engine.impl.history.event.HistoryEvent;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventProcessor;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventTypes;
import io.openbpm.bpm.engine.impl.history.producer.HistoryEventProducer;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.IncidentEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class SetAnnotationForIncidentCmd
implements Command<Void> {
    protected String incidentId;
    protected String annotation;

    public SetAnnotationForIncidentCmd(String incidentId, String annotation) {
        this.incidentId = incidentId;
        this.annotation = annotation;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        String tenantId;
        EnsureUtil.ensureNotNull(NotValidException.class, "incident id", (Object)this.incidentId);
        IncidentEntity incident = (IncidentEntity)commandContext.getIncidentManager().findIncidentById(this.incidentId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "incident", (Object)incident);
        ExecutionEntity execution = null;
        if (incident.getExecutionId() != null && (execution = commandContext.getExecutionManager().findExecutionById(incident.getExecutionId())) != null) {
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkUpdateProcessInstance(execution);
            }
        }
        incident.setAnnotation(this.annotation);
        this.triggerHistoryEvent(commandContext, incident);
        String string = tenantId = execution != null ? execution.getTenantId() : null;
        if (this.annotation == null) {
            commandContext.getOperationLogManager().logClearIncidentAnnotationOperation(this.incidentId, tenantId);
        } else {
            commandContext.getOperationLogManager().logSetIncidentAnnotationOperation(this.incidentId, tenantId);
        }
        return null;
    }

    protected void triggerHistoryEvent(CommandContext commandContext, final IncidentEntity incident) {
        HistoryLevel historyLevel = commandContext.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.INCIDENT_UPDATE, incident)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    HistoricIncidentEventEntity incidentUpdateEvt = (HistoricIncidentEventEntity)producer.createHistoricIncidentUpdateEvt(incident);
                    incidentUpdateEvt.setAnnotation(SetAnnotationForIncidentCmd.this.annotation);
                    return incidentUpdateEvt;
                }
            });
        }
    }
}

