/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cmd.AbstractSetVariableCmd;
import io.openbpm.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.Map;

public class SetExecutionVariablesCmd
extends AbstractSetVariableCmd {
    private static final long serialVersionUID = 1L;
    protected boolean failIfNotExists = true;

    public SetExecutionVariablesCmd(String executionId, Map<String, ?> variables, boolean isLocal, boolean skipJavaSerializationFormatCheck) {
        super(executionId, variables, isLocal, skipJavaSerializationFormatCheck);
    }

    public SetExecutionVariablesCmd(String executionId, Map<String, ?> variables, boolean isLocal, boolean skipJavaSerializationFormatCheck, boolean failIfNotExists) {
        this(executionId, variables, isLocal, skipJavaSerializationFormatCheck);
        this.failIfNotExists = failIfNotExists;
    }

    public SetExecutionVariablesCmd(String executionId, Map<String, ? extends Object> variables, boolean isLocal) {
        super(executionId, variables, isLocal, false);
    }

    @Override
    protected ExecutionEntity getEntity() {
        EnsureUtil.ensureNotNull("executionId", (Object)this.entityId);
        ExecutionEntity execution = this.commandContext.getExecutionManager().findExecutionById(this.entityId);
        if (this.failIfNotExists) {
            EnsureUtil.ensureNotNull("execution " + this.entityId + " doesn't exist", "execution", (Object)execution);
        }
        if (execution != null) {
            this.checkSetExecutionVariables(execution);
        }
        return execution;
    }

    @Override
    protected ExecutionEntity getContextExecution() {
        return this.getEntity();
    }

    @Override
    protected void logVariableOperation(AbstractVariableScope scope) {
        ExecutionEntity execution = (ExecutionEntity)scope;
        this.commandContext.getOperationLogManager().logVariableOperation(this.getLogEntryOperation(), execution.getId(), null, PropertyChange.EMPTY_CHANGE);
    }

    protected void checkSetExecutionVariables(ExecutionEntity execution) {
        for (CommandChecker checker : this.commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstanceVariables(execution);
        }
    }
}

