/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.impl.cmd.ExternalTaskCmd;
import io.openbpm.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.Collections;
import java.util.List;

public class SetExternalTaskRetriesCmd
extends ExternalTaskCmd {
    protected int retries;
    protected boolean shouldWriteUserOperationLog;

    public SetExternalTaskRetriesCmd(String externalTaskId, int retries, boolean shouldWriteUserOperationLog) {
        super(externalTaskId);
        this.retries = retries;
        this.shouldWriteUserOperationLog = shouldWriteUserOperationLog;
    }

    @Override
    protected void validateInput() {
        EnsureUtil.ensureGreaterThanOrEqual(BadUserRequestException.class, "The number of retries cannot be negative", "retries", this.retries, 0L);
    }

    @Override
    protected void execute(ExternalTaskEntity externalTask) {
        externalTask.setRetriesAndManageIncidents(this.retries);
    }

    @Override
    protected String getUserOperationLogOperationType() {
        if (this.shouldWriteUserOperationLog) {
            return "SetExternalTaskRetries";
        }
        return super.getUserOperationLogOperationType();
    }

    @Override
    protected List<PropertyChange> getUserOperationLogPropertyChanges(ExternalTaskEntity externalTask) {
        if (this.shouldWriteUserOperationLog) {
            return Collections.singletonList(new PropertyChange("retries", externalTask.getRetries(), this.retries));
        }
        return super.getUserOperationLogPropertyChanges(externalTask);
    }
}

