/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.oplog.UserOperationLogContext;
import io.openbpm.bpm.engine.impl.oplog.UserOperationLogContextEntry;
import io.openbpm.bpm.engine.impl.oplog.UserOperationLogContextEntryBuilder;
import io.openbpm.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class SetJobDefinitionPriorityCmd
implements Command<Void> {
    public static final String JOB_DEFINITION_OVERRIDING_PRIORITY = "overridingPriority";
    protected String jobDefinitionId;
    protected Long priority;
    protected boolean cascade;

    public SetJobDefinitionPriorityCmd(String jobDefinitionId, Long priority, boolean cascade) {
        this.jobDefinitionId = jobDefinitionId;
        this.priority = priority;
        this.cascade = cascade;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(NotValidException.class, "jobDefinitionId", (Object)this.jobDefinitionId);
        JobDefinitionEntity jobDefinition = commandContext.getJobDefinitionManager().findById(this.jobDefinitionId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Job definition with id '" + this.jobDefinitionId + "' does not exist", "jobDefinition", (Object)jobDefinition);
        this.checkUpdateProcess(commandContext, jobDefinition);
        Long currentPriority = jobDefinition.getOverridingJobPriority();
        jobDefinition.setJobPriority(this.priority);
        UserOperationLogContext opLogContext = new UserOperationLogContext();
        this.createJobDefinitionOperationLogEntry(opLogContext, currentPriority, jobDefinition);
        if (this.cascade && this.priority != null) {
            commandContext.getJobManager().updateJobPriorityByDefinitionId(this.jobDefinitionId, this.priority);
            this.createCascadeJobsOperationLogEntry(opLogContext, jobDefinition);
        }
        commandContext.getOperationLogManager().logUserOperations(opLogContext);
        return null;
    }

    protected void checkUpdateProcess(CommandContext commandContext, JobDefinitionEntity jobDefinition) {
        String processDefinitionId = jobDefinition.getProcessDefinitionId();
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessDefinitionById(processDefinitionId);
            if (!this.cascade) continue;
            checker.checkUpdateProcessInstanceByProcessDefinitionId(processDefinitionId);
        }
    }

    protected void createJobDefinitionOperationLogEntry(UserOperationLogContext opLogContext, Long previousPriority, JobDefinitionEntity jobDefinition) {
        PropertyChange propertyChange = new PropertyChange(JOB_DEFINITION_OVERRIDING_PRIORITY, previousPriority, jobDefinition.getOverridingJobPriority());
        UserOperationLogContextEntry entry = UserOperationLogContextEntryBuilder.entry("SetPriority", "JobDefinition").inContextOf(jobDefinition).propertyChanges(propertyChange).category("Operator").create();
        opLogContext.addEntry(entry);
    }

    protected void createCascadeJobsOperationLogEntry(UserOperationLogContext opLogContext, JobDefinitionEntity jobDefinition) {
        PropertyChange propertyChange = new PropertyChange("priority", null, jobDefinition.getOverridingJobPriority());
        UserOperationLogContextEntry entry = UserOperationLogContextEntryBuilder.entry("SetPriority", "Job").inContextOf(jobDefinition).propertyChanges(propertyChange).category("Operator").create();
        opLogContext.addEntry(entry);
    }
}

