/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class SetJobPriorityCmd
implements Command<Void> {
    public static final String JOB_PRIORITY_PROPERTY = "priority";
    protected String jobId;
    protected long priority;

    public SetJobPriorityCmd(String jobId, long priority) {
        this.jobId = jobId;
        this.priority = priority;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("job id must not be null", "jobId", (Object)this.jobId);
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "No job found with id '" + this.jobId + "'", "job", (Object)job);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateJob(job);
        }
        long currentPriority = job.getPriority();
        job.setPriority(this.priority);
        this.createOpLogEntry(commandContext, currentPriority, job);
        return null;
    }

    protected void createOpLogEntry(CommandContext commandContext, long previousPriority, JobEntity job) {
        PropertyChange propertyChange = new PropertyChange(JOB_PRIORITY_PROPERTY, previousPriority, job.getPriority());
        commandContext.getOperationLogManager().logJobOperation("SetPriority", job.getId(), job.getJobDefinitionId(), job.getProcessInstanceId(), job.getProcessDefinitionId(), job.getProcessDefinitionKey(), propertyChange);
    }
}

