/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.identity.Picture;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.IdentityInfoEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.repository.ResourceTypes;
import java.io.Serializable;

public class SetUserPictureCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected Picture picture;

    public SetUserPictureCmd(String userId, Picture picture) {
        this.userId = userId;
        this.picture = picture;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("userId", (Object)this.userId);
        IdentityInfoEntity pictureInfo = commandContext.getIdentityInfoManager().findUserInfoByUserIdAndKey(this.userId, "picture");
        if (pictureInfo != null) {
            String byteArrayId = pictureInfo.getValue();
            if (byteArrayId != null) {
                commandContext.getByteArrayManager().deleteByteArrayById(byteArrayId);
            }
        } else {
            pictureInfo = new IdentityInfoEntity();
            pictureInfo.setUserId(this.userId);
            pictureInfo.setKey("picture");
            commandContext.getDbEntityManager().insert(pictureInfo);
        }
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(this.picture.getMimeType(), this.picture.getBytes(), ResourceTypes.REPOSITORY);
        commandContext.getByteArrayManager().insertByteArray(byteArrayEntity);
        pictureInfo.setValue(byteArrayEntity.getId());
        return null;
    }
}

