/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.externaltask.ExternalTaskQuery;
import io.openbpm.bpm.engine.externaltask.UpdateExternalTaskRetriesBuilder;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.cmd.SetExternalTasksRetriesBatchCmd;
import io.openbpm.bpm.engine.impl.cmd.SetExternalTasksRetriesCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UpdateExternalTaskRetriesBuilderImpl
implements UpdateExternalTaskRetriesBuilder {
    protected CommandExecutor commandExecutor;
    protected List<String> externalTaskIds;
    protected List<String> processInstanceIds;
    protected ExternalTaskQuery externalTaskQuery;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;
    protected int retries;

    public UpdateExternalTaskRetriesBuilderImpl(List<String> externalTaskIds, int retries) {
        this.externalTaskIds = externalTaskIds;
        this.retries = retries;
    }

    public UpdateExternalTaskRetriesBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public UpdateExternalTaskRetriesBuilder externalTaskIds(List<String> externalTaskIds) {
        this.externalTaskIds = externalTaskIds;
        return this;
    }

    @Override
    public UpdateExternalTaskRetriesBuilder externalTaskIds(String ... externalTaskIds) {
        this.externalTaskIds = externalTaskIds == null ? Collections.emptyList() : Arrays.asList(externalTaskIds);
        return this;
    }

    @Override
    public UpdateExternalTaskRetriesBuilder processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public UpdateExternalTaskRetriesBuilder processInstanceIds(String ... processInstanceIds) {
        this.processInstanceIds = processInstanceIds == null ? Collections.emptyList() : Arrays.asList(processInstanceIds);
        return this;
    }

    @Override
    public UpdateExternalTaskRetriesBuilder externalTaskQuery(ExternalTaskQuery externalTaskQuery) {
        this.externalTaskQuery = externalTaskQuery;
        return this;
    }

    @Override
    public UpdateExternalTaskRetriesBuilder processInstanceQuery(ProcessInstanceQuery processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    @Override
    public UpdateExternalTaskRetriesBuilder historicProcessInstanceQuery(HistoricProcessInstanceQuery historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        return this;
    }

    @Override
    public void set(int retries) {
        this.retries = retries;
        this.commandExecutor.execute(new SetExternalTasksRetriesCmd(this));
    }

    @Override
    public Batch setAsync(int retries) {
        this.retries = retries;
        return this.commandExecutor.execute(new SetExternalTasksRetriesBatchCmd(this));
    }

    public int getRetries() {
        return this.retries;
    }

    public List<String> getExternalTaskIds() {
        return this.externalTaskIds;
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public ExternalTaskQuery getExternalTaskQuery() {
        return this.externalTaskQuery;
    }

    public ProcessInstanceQuery getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public HistoricProcessInstanceQuery getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }
}

