/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd.batch;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.authorization.BatchPermissions;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.batch.BatchConfiguration;
import io.openbpm.bpm.engine.impl.batch.BatchElementConfiguration;
import io.openbpm.bpm.engine.impl.batch.builder.BatchBuilder;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.commons.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeleteHistoricProcessInstancesBatchCmd
implements Command<Batch> {
    protected final String deleteReason;
    protected List<String> historicProcessInstanceIds;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;

    public DeleteHistoricProcessInstancesBatchCmd(List<String> historicProcessInstanceIds, HistoricProcessInstanceQuery historicProcessInstanceQuery, String deleteReason) {
        this.historicProcessInstanceIds = historicProcessInstanceIds;
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        this.deleteReason = deleteReason;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = this.collectHistoricProcessInstanceIds(commandContext);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicProcessInstanceIds", elementConfiguration.getIds());
        return new BatchBuilder(commandContext).type("historic-instance-deletion").config(this.getConfiguration(elementConfiguration)).permission(BatchPermissions.CREATE_BATCH_DELETE_FINISHED_PROCESS_INSTANCES).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected BatchElementConfiguration collectHistoricProcessInstanceIds(CommandContext commandContext) {
        HistoricProcessInstanceQueryImpl processInstanceQuery;
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        List<String> processInstanceIds = this.getHistoricProcessInstanceIds();
        if (!CollectionUtil.isEmpty(processInstanceIds)) {
            HistoricProcessInstanceQueryImpl query = new HistoricProcessInstanceQueryImpl();
            query.processInstanceIds(new HashSet<String>(processInstanceIds));
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(query::listDeploymentIdMappings), processInstanceIds);
        }
        if ((processInstanceQuery = (HistoricProcessInstanceQueryImpl)this.historicProcessInstanceQuery) != null) {
            elementConfiguration.addDeploymentMappings(processInstanceQuery.listDeploymentIdMappings());
        }
        return elementConfiguration;
    }

    public List<String> getHistoricProcessInstanceIds() {
        return this.historicProcessInstanceIds;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        propertyChanges.add(new PropertyChange("deleteReason", null, this.deleteReason));
        commandContext.getOperationLogManager().logProcessInstanceOperation("DeleteHistory", null, null, null, propertyChanges);
    }

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new BatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings(), false);
    }
}

