/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd.batch.variables;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.authorization.BatchPermissions;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.ProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.batch.BatchConfiguration;
import io.openbpm.bpm.engine.impl.batch.BatchElementConfiguration;
import io.openbpm.bpm.engine.impl.batch.DeploymentMappings;
import io.openbpm.bpm.engine.impl.batch.builder.BatchBuilder;
import io.openbpm.bpm.engine.impl.core.variable.VariableUtil;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.impl.util.ImmutablePair;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import io.openbpm.commons.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SetVariablesToProcessInstancesBatchCmd
implements Command<Batch> {
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;
    protected Map<String, ?> variables;

    public SetVariablesToProcessInstancesBatchCmd(List<String> processInstanceIds, ProcessInstanceQuery processInstanceQuery, HistoricProcessInstanceQuery historicProcessInstanceQuery, Map<String, ?> variables) {
        this.processInstanceIds = processInstanceIds;
        this.processInstanceQuery = processInstanceQuery;
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        this.variables = variables;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("variables", this.variables);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "variables", this.variables);
        EnsureUtil.ensureAtLeastOneNotNull("No process instances found.", this.processInstanceIds, this.processInstanceQuery, this.historicProcessInstanceQuery);
        BatchElementConfiguration elementConfiguration = this.collectProcessInstanceIds(commandContext);
        List<String> ids = elementConfiguration.getIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceIds", ids);
        BatchConfiguration configuration = this.getConfiguration(elementConfiguration);
        Batch batch = new BatchBuilder(commandContext).type("set-variables").config(configuration).permission(BatchPermissions.CREATE_BATCH_SET_VARIABLES).operationLogHandler(this::writeUserOperationLog).build();
        String batchId = batch.getId();
        VariableUtil.setVariablesByBatchId(this.variables, batchId);
        return batch;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int instancesCount) {
        ArrayList<PropertyChange> propChanges = new ArrayList<PropertyChange>();
        int variablesCount = this.variables.size();
        propChanges.add(new PropertyChange("nrOfInstances", null, instancesCount));
        propChanges.add(new PropertyChange("nrOfVariables", null, variablesCount));
        propChanges.add(new PropertyChange("async", null, true));
        commandContext.getOperationLogManager().logProcessInstanceOperation("SetVariables", propChanges);
    }

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        DeploymentMappings mappings = elementConfiguration.getMappings();
        List<String> ids = elementConfiguration.getIds();
        return new BatchConfiguration(ids, mappings);
    }

    protected BatchElementConfiguration collectProcessInstanceIds(CommandContext commandContext) {
        HistoricProcessInstanceQueryImpl historicQuery;
        List mappings;
        ProcessInstanceQueryImpl query;
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        if (!CollectionUtil.isEmpty(this.processInstanceIds)) {
            query = new ProcessInstanceQueryImpl();
            query.processInstanceIds(new HashSet<String>(this.processInstanceIds));
            mappings = commandContext.runWithoutAuthorization(query::listDeploymentIdMappings);
            elementConfiguration.addDeploymentMappings(mappings);
        }
        if ((query = (ProcessInstanceQueryImpl)this.processInstanceQuery) != null) {
            mappings = query.listDeploymentIdMappings();
            elementConfiguration.addDeploymentMappings(mappings);
        }
        if ((historicQuery = (HistoricProcessInstanceQueryImpl)this.historicProcessInstanceQuery) != null) {
            historicQuery.unfinished();
            List<ImmutablePair<String, String>> mappings2 = historicQuery.listDeploymentIdMappings();
            elementConfiguration.addDeploymentMappings(mappings2);
        }
        return elementConfiguration;
    }
}

