/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmmn.cmd;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import io.openbpm.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import java.io.InputStream;
import java.io.Serializable;

public class GetDeploymentCaseDiagramCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;

    public GetDeploymentCaseDiagramCmd(String caseDefinitionId) {
        if (caseDefinitionId == null || caseDefinitionId.isEmpty()) {
            throw new ProcessEngineException("The case definition id is mandatory, but '" + caseDefinitionId + "' has been provided.");
        }
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        CaseDefinitionEntity caseDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedCaseDefinitionById(this.caseDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadCaseDefinition(caseDefinition);
        }
        String deploymentId = caseDefinition.getDeploymentId();
        String resourceName = caseDefinition.getDiagramResourceName();
        InputStream caseDiagramStream = null;
        if (resourceName != null) {
            caseDiagramStream = commandContext.runWithoutAuthorization(new GetDeploymentResourceCmd(deploymentId, resourceName));
        }
        return caseDiagramStream;
    }
}

