/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmmn.handler;

import io.openbpm.bpm.engine.delegate.TaskListener;
import io.openbpm.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import io.openbpm.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import io.openbpm.bpm.engine.impl.cmmn.behavior.HumanTaskActivityBehavior;
import io.openbpm.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import io.openbpm.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import io.openbpm.bpm.engine.impl.cmmn.handler.TaskItemHandler;
import io.openbpm.bpm.engine.impl.cmmn.model.CmmnActivity;
import io.openbpm.bpm.engine.impl.el.Expression;
import io.openbpm.bpm.engine.impl.el.ExpressionManager;
import io.openbpm.bpm.engine.impl.form.handler.DefaultTaskFormHandler;
import io.openbpm.bpm.engine.impl.scripting.ExecutableScript;
import io.openbpm.bpm.engine.impl.task.TaskDecorator;
import io.openbpm.bpm.engine.impl.task.TaskDefinition;
import io.openbpm.bpm.engine.impl.task.listener.ClassDelegateTaskListener;
import io.openbpm.bpm.engine.impl.task.listener.DelegateExpressionTaskListener;
import io.openbpm.bpm.engine.impl.task.listener.ExpressionTaskListener;
import io.openbpm.bpm.engine.impl.task.listener.ScriptTaskListener;
import io.openbpm.bpm.engine.repository.Deployment;
import io.openbpm.bpm.model.cmmn.instance.CmmnElement;
import io.openbpm.bpm.model.cmmn.instance.HumanTask;
import io.openbpm.bpm.model.cmmn.instance.Role;
import io.openbpm.bpm.model.cmmn.instance.operaton.OperatonScript;
import io.openbpm.bpm.model.cmmn.instance.operaton.OperatonTaskListener;
import java.util.Collection;
import java.util.List;

public class HumanTaskItemHandler
extends TaskItemHandler {
    @Override
    public CmmnActivity handleElement(CmmnElement element, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(element);
        if (!definition.isBlocking()) {
            return null;
        }
        return super.handleElement(element, context);
    }

    @Override
    protected void initializeActivity(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        super.initializeActivity(element, activity, context);
        TaskDefinition taskDefinition = this.createTaskDefinition(element, context);
        CaseDefinitionEntity caseDefinition = (CaseDefinitionEntity)context.getCaseDefinition();
        caseDefinition.getTaskDefinitions().put(taskDefinition.getKey(), taskDefinition);
        ExpressionManager expressionManager = context.getExpressionManager();
        TaskDecorator taskDecorator = new TaskDecorator(taskDefinition, expressionManager);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        behavior.setTaskDecorator(taskDecorator);
        this.initializeTaskListeners(element, activity, context, taskDefinition);
    }

    protected TaskDefinition createTaskDefinition(CmmnElement element, CmmnHandlerContext context) {
        Deployment deployment = context.getDeployment();
        String deploymentId = deployment.getId();
        DefaultTaskFormHandler taskFormHandler = new DefaultTaskFormHandler();
        taskFormHandler.setDeploymentId(deploymentId);
        TaskDefinition taskDefinition = new TaskDefinition(taskFormHandler);
        String taskDefinitionKey = element.getId();
        taskDefinition.setKey(taskDefinitionKey);
        this.initializeTaskDefinitionName(element, taskDefinition, context);
        this.initializeTaskDefinitionDueDate(element, taskDefinition, context);
        this.initializeTaskDefinitionFollowUpDate(element, taskDefinition, context);
        this.initializeTaskDefinitionPriority(element, taskDefinition, context);
        this.initializeTaskDefinitionAssignee(element, taskDefinition, context);
        this.initializeTaskDefinitionCandidateUsers(element, taskDefinition, context);
        this.initializeTaskDefinitionCandidateGroups(element, taskDefinition, context);
        this.initializeTaskDefinitionFormKey(element, taskDefinition, context);
        this.initializeTaskDescription(element, taskDefinition, context);
        return taskDefinition;
    }

    protected void initializeTaskDefinitionName(CmmnElement element, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        String name = this.getName(element);
        if (name == null) {
            HumanTask definition = this.getDefinition(element);
            name = definition.getName();
        }
        if (name != null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression nameExpression = expressionManager.createExpression(name);
            taskDefinition.setNameExpression(nameExpression);
        }
    }

    protected void initializeTaskDefinitionFormKey(CmmnElement element, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(element);
        String formKey = definition.getOperatonFormKey();
        if (formKey != null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression formKeyExpression = expressionManager.createExpression(formKey);
            taskDefinition.setFormKey(formKeyExpression);
        }
    }

    protected void initializeTaskDefinitionAssignee(CmmnElement element, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(element);
        Role performer = definition.getPerformer();
        String assignee = null;
        assignee = performer != null ? performer.getName() : definition.getOperatonAssignee();
        if (assignee != null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression assigneeExpression = expressionManager.createExpression(assignee);
            taskDefinition.setAssigneeExpression(assigneeExpression);
        }
    }

    protected void initializeTaskDefinitionCandidateUsers(CmmnElement element, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(element);
        ExpressionManager expressionManager = context.getExpressionManager();
        List candidateUsers = definition.getOperatonCandidateUsersList();
        for (String candidateUser : candidateUsers) {
            Expression candidateUserExpression = expressionManager.createExpression(candidateUser);
            taskDefinition.addCandidateUserIdExpression(candidateUserExpression);
        }
    }

    protected void initializeTaskDefinitionCandidateGroups(CmmnElement element, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(element);
        ExpressionManager expressionManager = context.getExpressionManager();
        List candidateGroups = definition.getOperatonCandidateGroupsList();
        for (String candidateGroup : candidateGroups) {
            Expression candidateGroupExpression = expressionManager.createExpression(candidateGroup);
            taskDefinition.addCandidateGroupIdExpression(candidateGroupExpression);
        }
    }

    protected void initializeTaskDefinitionDueDate(CmmnElement element, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(element);
        String dueDate = definition.getOperatonDueDate();
        if (dueDate != null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression dueDateExpression = expressionManager.createExpression(dueDate);
            taskDefinition.setDueDateExpression(dueDateExpression);
        }
    }

    protected void initializeTaskDefinitionFollowUpDate(CmmnElement element, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(element);
        String followUpDate = definition.getOperatonFollowUpDate();
        if (followUpDate != null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression followUpDateExpression = expressionManager.createExpression(followUpDate);
            taskDefinition.setFollowUpDateExpression(followUpDateExpression);
        }
    }

    protected void initializeTaskDefinitionPriority(CmmnElement element, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(element);
        String priority = definition.getOperatonPriority();
        if (priority != null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression priorityExpression = expressionManager.createExpression(priority);
            taskDefinition.setPriorityExpression(priorityExpression);
        }
    }

    protected void initializeTaskDescription(CmmnElement element, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        String description = this.getDesciption(element);
        if (description != null && !description.isEmpty()) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression descriptionExpression = expressionManager.createExpression(description);
            taskDefinition.setDescriptionExpression(descriptionExpression);
        } else {
            String documentation = this.getDocumentation(element);
            if (documentation != null && !documentation.isEmpty()) {
                ExpressionManager expressionManager = context.getExpressionManager();
                Expression documentationExpression = expressionManager.createExpression(documentation);
                taskDefinition.setDescriptionExpression(documentationExpression);
            }
        }
    }

    protected void initializeTaskListeners(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, TaskDefinition taskDefinition) {
        HumanTask humanTask = this.getDefinition(element);
        List<OperatonTaskListener> listeners = this.queryExtensionElementsByClass((CmmnElement)humanTask, OperatonTaskListener.class);
        for (OperatonTaskListener listener : listeners) {
            TaskListener taskListener = this.initializeTaskListener(element, activity, context, listener);
            String eventName = listener.getOperatonEvent();
            if (eventName != null) {
                taskDefinition.addTaskListener(eventName, taskListener);
                continue;
            }
            taskDefinition.addTaskListener("create", taskListener);
            taskDefinition.addTaskListener("assignment", taskListener);
            taskDefinition.addTaskListener("complete", taskListener);
            taskDefinition.addTaskListener("update", taskListener);
            taskDefinition.addTaskListener("delete", taskListener);
        }
    }

    protected TaskListener initializeTaskListener(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, OperatonTaskListener listener) {
        ExecutableScript executableScript;
        Collection fields = listener.getOperatonFields();
        List<FieldDeclaration> fieldDeclarations = this.initializeFieldDeclarations(element, activity, context, fields);
        ExpressionManager expressionManager = context.getExpressionManager();
        TaskListener taskListener = null;
        String className = listener.getOperatonClass();
        String expression = listener.getOperatonExpression();
        String delegateExpression = listener.getOperatonDelegateExpression();
        OperatonScript scriptElement = listener.getOperatonScript();
        if (className != null) {
            taskListener = new ClassDelegateTaskListener(className, fieldDeclarations);
        } else if (expression != null) {
            Expression expressionExp = expressionManager.createExpression(expression);
            taskListener = new ExpressionTaskListener(expressionExp);
        } else if (delegateExpression != null) {
            Expression delegateExp = expressionManager.createExpression(delegateExpression);
            taskListener = new DelegateExpressionTaskListener(delegateExp, fieldDeclarations);
        } else if (scriptElement != null && (executableScript = this.initializeScript(element, activity, context, scriptElement)) != null) {
            taskListener = new ScriptTaskListener(executableScript);
        }
        return taskListener;
    }

    protected HumanTask getDefinition(CmmnElement element) {
        return (HumanTask)super.getDefinition(element);
    }

    @Override
    protected CmmnActivityBehavior getActivityBehavior() {
        return new HumanTaskActivityBehavior();
    }
}

