/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.context;

import io.openbpm.bpm.application.InvocationContext;
import io.openbpm.bpm.application.ProcessApplicationInterface;
import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.application.ProcessApplicationUnavailableException;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import io.openbpm.bpm.engine.impl.context.BpmnExecutionContext;
import io.openbpm.bpm.engine.impl.context.CaseExecutionContext;
import io.openbpm.bpm.engine.impl.context.CoreExecutionContext;
import io.openbpm.bpm.engine.impl.context.ExecutionContext;
import io.openbpm.bpm.engine.impl.context.ProcessApplicationClassloaderInterceptor;
import io.openbpm.bpm.engine.impl.core.instance.CoreExecution;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandInvocationContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutorContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Callable;

public final class Context {
    protected static ThreadLocal<Deque<CommandContext>> commandContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Deque<CommandInvocationContext>> commandInvocationContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Deque<ProcessEngineConfigurationImpl>> processEngineConfigurationStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Deque<CoreExecutionContext<? extends CoreExecution>>> executionContextStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<JobExecutorContext> jobExecutorContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Deque<ProcessApplicationReference>> processApplicationContext = new ThreadLocal();

    public static CommandContext getCommandContext() {
        Deque stack = Context.getStack(commandContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandContext)stack.peek();
    }

    public static void setCommandContext(CommandContext commandContext) {
        Context.getStack(commandContextThreadLocal).push(commandContext);
    }

    public static void removeCommandContext() {
        Context.getStack(commandContextThreadLocal).pop();
    }

    public static CommandInvocationContext getCommandInvocationContext() {
        Deque stack = Context.getStack(commandInvocationContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandInvocationContext)stack.peek();
    }

    public static void setCommandInvocationContext(CommandInvocationContext commandInvocationContext) {
        Context.getStack(commandInvocationContextThreadLocal).push(commandInvocationContext);
    }

    public static void removeCommandInvocationContext() {
        Deque stack = Context.getStack(commandInvocationContextThreadLocal);
        CommandInvocationContext currentContext = (CommandInvocationContext)stack.pop();
        if (stack.isEmpty()) {
            if (Context.getJobExecutorContext() == null) {
                currentContext.getProcessDataContext().clearMdc();
                currentContext.getProcessDataContext().restoreExternalMDCProperties();
            }
        } else {
            ((CommandInvocationContext)stack.peek()).getProcessDataContext().updateMdcFromCurrentValues();
        }
    }

    public static ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        Deque stack = Context.getStack(processEngineConfigurationStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (ProcessEngineConfigurationImpl)stack.peek();
    }

    public static void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Context.getStack(processEngineConfigurationStackThreadLocal).push(processEngineConfiguration);
    }

    public static void removeProcessEngineConfiguration() {
        Context.getStack(processEngineConfigurationStackThreadLocal).pop();
    }

    @Deprecated(forRemoval=true, since="1.0")
    public static ExecutionContext getExecutionContext() {
        return Context.getBpmnExecutionContext();
    }

    public static BpmnExecutionContext getBpmnExecutionContext() {
        return (BpmnExecutionContext)Context.getCoreExecutionContext();
    }

    public static CaseExecutionContext getCaseExecutionContext() {
        return (CaseExecutionContext)Context.getCoreExecutionContext();
    }

    public static CoreExecutionContext<? extends CoreExecution> getCoreExecutionContext() {
        Deque stack = Context.getStack(executionContextStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CoreExecutionContext)stack.peek();
    }

    public static void setExecutionContext(ExecutionEntity execution) {
        Context.getStack(executionContextStackThreadLocal).push(new BpmnExecutionContext(execution));
    }

    public static void setExecutionContext(CaseExecutionEntity execution) {
        Context.getStack(executionContextStackThreadLocal).push(new CaseExecutionContext(execution));
    }

    public static void removeExecutionContext() {
        Context.getStack(executionContextStackThreadLocal).pop();
    }

    protected static <T> Deque<T> getStack(ThreadLocal<Deque<T>> threadLocal) {
        Deque<T> stack = threadLocal.get();
        if (stack == null) {
            stack = new ArrayDeque<T>();
            threadLocal.set(stack);
        }
        return stack;
    }

    public static JobExecutorContext getJobExecutorContext() {
        return jobExecutorContextThreadLocal.get();
    }

    public static void setJobExecutorContext(JobExecutorContext jobExecutorContext) {
        jobExecutorContextThreadLocal.set(jobExecutorContext);
    }

    public static void removeJobExecutorContext() {
        jobExecutorContextThreadLocal.remove();
    }

    public static ProcessApplicationReference getCurrentProcessApplication() {
        Deque stack = Context.getStack(processApplicationContext);
        if (stack.isEmpty()) {
            return null;
        }
        return (ProcessApplicationReference)stack.peek();
    }

    public static void setCurrentProcessApplication(ProcessApplicationReference reference) {
        Deque stack = Context.getStack(processApplicationContext);
        stack.push(reference);
    }

    public static void removeCurrentProcessApplication() {
        Deque stack = Context.getStack(processApplicationContext);
        stack.pop();
    }

    public static <T> T executeWithinProcessApplication(Callable<T> callback, ProcessApplicationReference processApplicationReference) {
        return Context.executeWithinProcessApplication(callback, processApplicationReference, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeWithinProcessApplication(Callable<T> callback, ProcessApplicationReference processApplicationReference, InvocationContext invocationContext) {
        String paName = processApplicationReference.getName();
        try {
            ProcessApplicationInterface processApplication = processApplicationReference.getProcessApplication();
            Context.setCurrentProcessApplication(processApplicationReference);
            try {
                ProcessApplicationClassloaderInterceptor<T> wrappedCallback = new ProcessApplicationClassloaderInterceptor<T>(callback);
                T t = processApplication.execute(wrappedCallback, invocationContext);
                return t;
            }
            catch (Exception e) {
                Throwable throwable = e.getCause();
                if (!(throwable instanceof RuntimeException)) throw new ProcessEngineException("Unexpected exeption while executing within process application ", e);
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            finally {
                Context.removeCurrentProcessApplication();
            }
        }
        catch (ProcessApplicationUnavailableException e) {
            throw new ProcessEngineException("Cannot switch to process application '" + paName + "' for execution: " + e.getMessage(), e);
        }
    }

    private Context() {
    }
}

