/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.core.variable;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.core.CoreLogger;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.util.TypedValueField;
import io.openbpm.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import io.openbpm.bpm.engine.impl.variable.serializer.VariableSerializerFactory;
import io.openbpm.bpm.engine.variable.VariableMap;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.value.SerializableValue;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class VariableUtil {
    public static final CommandLogger CMD_LOGGER = ProcessEngineLogger.CMD_LOGGER;
    public static final CoreLogger CORE_LOGGER = ProcessEngineLogger.CORE_LOGGER;
    public static final String ERROR_MSG = "Cannot set variable with name {0}. Java serialization format is prohibited";

    private VariableUtil() {
    }

    public static boolean isJavaSerializationProhibited(TypedValue value) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (value instanceof SerializableValue) {
            SerializableValue serializableValue = (SerializableValue)value;
            if (!processEngineConfiguration.isJavaSerializationFormatEnabled() && !serializableValue.isDeserialized()) {
                String requestedDataFormat = serializableValue.getSerializationDataFormat();
                if (requestedDataFormat == null) {
                    VariableSerializerFactory fallbackSerializerFactory = processEngineConfiguration.getFallbackSerializerFactory();
                    TypedValueSerializer serializerForValue = TypedValueField.getSerializers().findSerializerForValue((TypedValue)serializableValue, fallbackSerializerFactory);
                    if (serializerForValue != null) {
                        requestedDataFormat = serializerForValue.getSerializationDataformat();
                    }
                }
                return Variables.SerializationDataFormats.JAVA.getName().equals(requestedDataFormat);
            }
        }
        return false;
    }

    public static void checkJavaSerialization(String variableName, TypedValue value) {
        if (VariableUtil.isJavaSerializationProhibited(value)) {
            throw CORE_LOGGER.javaSerializationProhibitedException(variableName);
        }
    }

    public static void setVariables(Map<String, ?> variables, SetVariableFunction setVariableFunction) {
        if (variables != null) {
            for (Map.Entry<String, ?> vars : variables.entrySet()) {
                String variableName = vars.getKey();
                TypedValue value = null;
                if (variables instanceof VariableMap) {
                    VariableMap map = (VariableMap)variables;
                    value = map.getValueTyped(variableName);
                } else {
                    value = (TypedValue)vars.getValue();
                }
                setVariableFunction.apply(variableName, value);
            }
        }
    }

    public static void setVariablesByBatchId(Map<String, ?> variables, String batchId) {
        VariableUtil.setVariables(variables, (name, value) -> VariableUtil.setVariableByBatchId(batchId, name, value));
    }

    public static void setVariableByBatchId(String batchId, String variableName, Object variableValue) {
        TypedValue variableTypedValue = Variables.untypedValue((Object)variableValue);
        boolean isTransient = variableTypedValue.isTransient();
        if (isTransient) {
            throw CMD_LOGGER.exceptionSettingTransientVariablesAsyncNotSupported(variableName);
        }
        VariableUtil.checkJavaSerialization(variableName, variableTypedValue);
        VariableInstanceEntity variableInstance = VariableInstanceEntity.createAndInsert(variableName, variableTypedValue);
        variableInstance.setVariableScopeId(batchId);
        variableInstance.setBatchId(batchId);
    }

    public static Map<String, ?> findBatchVariablesSerialized(String batchId, CommandContext commandContext) {
        List<VariableInstanceEntity> variableInstances = commandContext.getVariableInstanceManager().findVariableInstancesByBatchId(batchId);
        return variableInstances.stream().collect(VariableUtil.variablesCollector());
    }

    protected static Collector<VariableInstanceEntity, ?, Map<String, TypedValue>> variablesCollector() {
        return Collectors.toMap(VariableInstanceEntity::getName, VariableUtil::getSerializedValue);
    }

    protected static TypedValue getSerializedValue(VariableInstanceEntity variableInstanceEntity) {
        return variableInstanceEntity.getTypedValue(false);
    }

    @FunctionalInterface
    public static interface SetVariableFunction {
        public void apply(String var1, Object var2);
    }
}

