/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.delegate;

import io.openbpm.bpm.application.InvocationContext;
import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.engine.delegate.BaseDelegateExecution;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.context.CoreExecutionContext;
import io.openbpm.bpm.engine.impl.context.ProcessApplicationContextUtil;
import io.openbpm.bpm.engine.impl.core.instance.CoreExecution;
import io.openbpm.bpm.engine.impl.delegate.DelegateInvocation;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.DelegateInterceptor;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.repository.ResourceDefinitionEntity;

public class DefaultDelegateInterceptor
implements DelegateInterceptor {
    @Override
    public void handleInvocation(DelegateInvocation invocation) throws Exception {
        ProcessApplicationReference processApplication = this.getProcessApplicationForInvocation(invocation);
        if (processApplication != null && ProcessApplicationContextUtil.requiresContextSwitch(processApplication)) {
            Context.executeWithinProcessApplication(() -> {
                this.handleInvocation(invocation);
                return null;
            }, processApplication, new InvocationContext(invocation.getContextExecution()));
        } else {
            this.handleInvocationInContext(invocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInvocationInContext(DelegateInvocation invocation) throws Exception {
        CommandContext commandContext = Context.getCommandContext();
        boolean wasAuthorizationCheckEnabled = commandContext.isAuthorizationCheckEnabled();
        boolean wasUserOperationLogEnabled = commandContext.isUserOperationLogEnabled();
        BaseDelegateExecution contextExecution = invocation.getContextExecution();
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        boolean popExecutionContext = false;
        try {
            if (!configuration.isAuthorizationEnabledForCustomCode()) {
                commandContext.disableAuthorizationCheck();
            }
            try {
                commandContext.disableUserOperationLog();
                try {
                    if (contextExecution != null && !this.isCurrentContextExecution(contextExecution)) {
                        popExecutionContext = this.setExecutionContext(contextExecution);
                    }
                    invocation.proceed();
                }
                finally {
                    if (popExecutionContext) {
                        Context.removeExecutionContext();
                    }
                }
            }
            finally {
                if (wasUserOperationLogEnabled) {
                    commandContext.enableUserOperationLog();
                }
            }
        }
        finally {
            if (wasAuthorizationCheckEnabled) {
                commandContext.enableAuthorizationCheck();
            }
        }
    }

    protected boolean setExecutionContext(BaseDelegateExecution execution) {
        if (execution instanceof ExecutionEntity) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            Context.setExecutionContext(executionEntity);
            return true;
        }
        if (execution instanceof CaseExecutionEntity) {
            CaseExecutionEntity caseExecutionEntity = (CaseExecutionEntity)execution;
            Context.setExecutionContext(caseExecutionEntity);
            return true;
        }
        return false;
    }

    protected boolean isCurrentContextExecution(BaseDelegateExecution execution) {
        CoreExecutionContext<? extends CoreExecution> coreExecutionContext = Context.getCoreExecutionContext();
        return coreExecutionContext != null && coreExecutionContext.getExecution() == execution;
    }

    protected ProcessApplicationReference getProcessApplicationForInvocation(DelegateInvocation invocation) {
        BaseDelegateExecution contextExecution = invocation.getContextExecution();
        ResourceDefinitionEntity contextResource = invocation.getContextResource();
        if (contextExecution != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication((CoreExecution)contextExecution);
        }
        if (contextResource != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication(contextResource);
        }
        return null;
    }
}

