/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.dmn.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.ArrayList;
import java.util.List;

public class DeleteHistoricDecisionInstancesBulkCmd
implements Command<Object> {
    protected final List<String> decisionInstanceIds;

    public DeleteHistoricDecisionInstancesBulkCmd(List<String> decisionInstanceIds) {
        this.decisionInstanceIds = decisionInstanceIds;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.DECISION_DEFINITION);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "decisionInstanceIds", this.decisionInstanceIds);
        this.writeUserOperationLog(commandContext, this.decisionInstanceIds.size());
        commandContext.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstanceByIds(this.decisionInstanceIds);
        return null;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, false));
        commandContext.getOperationLogManager().logDecisionInstanceOperation("DeleteHistory", null, propertyChanges);
    }
}

