/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.el;

import io.openbpm.bpm.dmn.engine.impl.spi.el.ElProvider;
import io.openbpm.bpm.engine.delegate.VariableScope;
import io.openbpm.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import io.openbpm.bpm.engine.impl.dmn.el.ProcessEngineJuelElProvider;
import io.openbpm.bpm.engine.impl.el.ElProviderCompatible;
import io.openbpm.bpm.engine.impl.el.Expression;
import io.openbpm.bpm.engine.impl.el.ExpressionManager;
import io.openbpm.bpm.engine.impl.el.JuelExpression;
import io.openbpm.bpm.engine.impl.el.ProcessApplicationBeanElResolverDelegate;
import io.openbpm.bpm.engine.impl.el.ProcessApplicationElResolverDelegate;
import io.openbpm.bpm.engine.impl.el.ProcessEngineElContext;
import io.openbpm.bpm.engine.impl.el.ReadOnlyMapELResolver;
import io.openbpm.bpm.engine.impl.el.VariableContextElResolver;
import io.openbpm.bpm.engine.impl.el.VariableScopeElResolver;
import io.openbpm.bpm.engine.impl.mock.MockElResolver;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.variable.context.VariableContext;
import io.openbpm.bpm.impl.juel.ExpressionFactoryImpl;
import jakarta.el.ArrayELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.FunctionMapper;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ValueExpression;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class JuelExpressionManager
implements ExpressionManager,
ElProviderCompatible {
    protected Map<String, Method> functions = new HashMap<String, Method>();
    protected ExpressionFactory expressionFactory = new ExpressionFactoryImpl();
    protected Map<Object, Object> beans;
    protected volatile boolean initialized;
    protected ELResolver elResolver;
    protected FunctionMapper functionMapper;
    protected ELContext parsingElContext;
    protected volatile ElProvider elProvider;

    public JuelExpressionManager() {
        this(null);
    }

    public JuelExpressionManager(Map<Object, Object> beans) {
        this.beans = beans;
    }

    @Override
    public Expression createExpression(String expression) {
        this.ensureInitialized();
        ValueExpression valueExpression = this.createValueExpression(expression);
        return new JuelExpression(valueExpression, this, expression);
    }

    @Override
    public void addFunction(String name, Method function) {
        EnsureUtil.ensureNotEmpty("name", name);
        EnsureUtil.ensureNotNull("function", (Object)function);
        this.functions.put(name, function);
    }

    public ValueExpression createValueExpression(String expression) {
        this.ensureInitialized();
        return this.expressionFactory.createValueExpression(this.parsingElContext, expression, Object.class);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public ELContext getElContext(VariableScope variableScope) {
        this.ensureInitialized();
        ELContext elContext = null;
        if (variableScope instanceof AbstractVariableScope) {
            AbstractVariableScope variableScopeImpl = (AbstractVariableScope)variableScope;
            elContext = variableScopeImpl.getCachedElContext();
        }
        if (elContext == null) {
            elContext = this.createElContext(variableScope);
            if (variableScope instanceof AbstractVariableScope) {
                AbstractVariableScope abstractVariableScope = (AbstractVariableScope)variableScope;
                abstractVariableScope.setCachedElContext(elContext);
            }
        }
        return elContext;
    }

    public ELContext createElContext(VariableContext variableContext) {
        this.ensureInitialized();
        ProcessEngineElContext elContext = new ProcessEngineElContext(this.functionMapper, this.elResolver);
        elContext.putContext(ExpressionFactory.class, this.expressionFactory);
        elContext.putContext(VariableContext.class, variableContext);
        return elContext;
    }

    protected ProcessEngineElContext createElContext(VariableScope variableScope) {
        this.ensureInitialized();
        ProcessEngineElContext elContext = new ProcessEngineElContext(this.functionMapper, this.elResolver);
        elContext.putContext(ExpressionFactory.class, this.expressionFactory);
        if (variableScope != null) {
            elContext.putContext(VariableScope.class, variableScope);
        }
        return elContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureInitialized() {
        if (!this.initialized) {
            JuelExpressionManager juelExpressionManager = this;
            synchronized (juelExpressionManager) {
                if (!this.initialized) {
                    this.elResolver = this.createElResolver();
                    this.functionMapper = this.createFunctionMapper();
                    this.parsingElContext = new ProcessEngineElContext(this.functionMapper);
                    this.initialized = true;
                }
            }
        }
    }

    protected ELResolver createElResolver() {
        CompositeELResolver compositeELResolver = new CompositeELResolver();
        compositeELResolver.add((ELResolver)new VariableScopeElResolver());
        compositeELResolver.add((ELResolver)new VariableContextElResolver());
        compositeELResolver.add((ELResolver)new MockElResolver());
        if (this.beans != null) {
            compositeELResolver.add((ELResolver)new ReadOnlyMapELResolver(this.beans));
        }
        compositeELResolver.add((ELResolver)new ProcessApplicationElResolverDelegate());
        compositeELResolver.add((ELResolver)new ArrayELResolver());
        compositeELResolver.add((ELResolver)new ListELResolver());
        compositeELResolver.add((ELResolver)new MapELResolver());
        compositeELResolver.add((ELResolver)new ProcessApplicationBeanElResolverDelegate());
        return compositeELResolver;
    }

    protected FunctionMapper createFunctionMapper() {
        return new FunctionMapper(){

            public Method resolveFunction(String prefix, String localName) {
                Object fullName = localName;
                if (prefix != null && !prefix.trim().isEmpty()) {
                    fullName = prefix + ":" + localName;
                }
                return JuelExpressionManager.this.functions.get(fullName);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElProvider toElProvider() {
        if (this.elProvider == null) {
            JuelExpressionManager juelExpressionManager = this;
            synchronized (juelExpressionManager) {
                if (this.elProvider == null) {
                    this.elProvider = this.createElProvider();
                }
            }
        }
        return this.elProvider;
    }

    protected ElProvider createElProvider() {
        return new ProcessEngineJuelElProvider(this);
    }
}

