/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.event;

import io.openbpm.bpm.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.helper.BpmnProperties;
import io.openbpm.bpm.engine.impl.event.EventHandler;
import io.openbpm.bpm.engine.impl.event.EventType;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.Map;

public class EventHandlerImpl
implements EventHandler {
    private final EventType eventType;

    public EventHandlerImpl(EventType eventType) {
        this.eventType = eventType;
    }

    public void handleIntermediateEvent(EventSubscriptionEntity eventSubscription, Object payload, Object localPayload, Object payloadToTriggeredScope, CommandContext commandContext) {
        ExecutionEntity execution = eventSubscription.getExecution();
        ActivityImpl activity = eventSubscription.getActivity();
        EnsureUtil.ensureNotNull("Error while sending signal for event subscription '" + eventSubscription.getId() + "': no activity associated with event subscription", "activity", (Object)activity);
        if (payload instanceof Map) {
            execution.setVariables((Map<String, ?>)((Map)payload));
        }
        if (localPayload instanceof Map) {
            execution.setVariablesLocal((Map<String, ?>)((Map)localPayload));
        }
        if (payloadToTriggeredScope instanceof Map) {
            if ("intermediateMessageCatch".equals(activity.getProperty(BpmnProperties.TYPE.name()))) {
                execution.setVariablesLocal((Map<String, ?>)((Map)payloadToTriggeredScope));
            } else {
                ((PvmExecutionImpl)execution).getProcessInstance().setPayloadForTriggeredScope((Map)payloadToTriggeredScope);
            }
        }
        if (activity.equals(((PvmExecutionImpl)execution).getActivity())) {
            execution.signal("signal", null);
        } else {
            if (activity.getActivityBehavior() instanceof EventSubProcessStartEventActivityBehavior) {
                activity = (ActivityImpl)activity.getFlowScope();
            }
            execution.executeEventHandlerActivity(activity);
        }
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, Object localPayload, Object payloadToTriggeredScope, String businessKey, CommandContext commandContext) {
        this.handleIntermediateEvent(eventSubscription, payload, localPayload, payloadToTriggeredScope, commandContext);
    }

    @Override
    public String getEventHandlerType() {
        return this.eventType.name();
    }
}

