/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.event;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.event.EventHandlerImpl;
import io.openbpm.bpm.engine.impl.event.EventType;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.Map;

public class SignalEventHandler
extends EventHandlerImpl {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;

    public SignalEventHandler() {
        super(EventType.SIGNAL);
    }

    protected void handleStartEvent(EventSubscriptionEntity eventSubscription, Map<String, Object> payload, String businessKey, CommandContext commandContext) {
        String processDefinitionId = eventSubscription.getConfiguration();
        EnsureUtil.ensureNotNull("Configuration of signal start event subscription '" + eventSubscription.getId() + "' contains no process definition id.", (Object)processDefinitionId);
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
        if (processDefinition == null || processDefinition.isSuspended()) {
            LOG.debugIgnoringEventSubscription(eventSubscription, processDefinitionId);
        } else {
            ActivityImpl signalStartEvent = processDefinition.findActivity(eventSubscription.getActivityId());
            ExecutionEntity processInstance = processDefinition.createProcessInstance(businessKey, signalStartEvent);
            processInstance.start(payload);
        }
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, Object payloadLocal, Object payloadToTriggeredScope, String businessKey, CommandContext commandContext) {
        if (eventSubscription.getExecutionId() != null) {
            this.handleIntermediateEvent(eventSubscription, payload, payloadLocal, null, commandContext);
        } else {
            this.handleStartEvent(eventSubscription, (Map)payload, businessKey, commandContext);
        }
    }
}

