/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.externaltask;

import io.openbpm.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;
import io.openbpm.bpm.engine.externaltask.LockedExternalTask;
import io.openbpm.bpm.engine.impl.QueryOrderingProperty;
import io.openbpm.bpm.engine.impl.cmd.FetchExternalTasksCmd;
import io.openbpm.bpm.engine.impl.externaltask.TopicFetchInstruction;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExternalTaskQueryTopicBuilderImpl
implements ExternalTaskQueryTopicBuilder {
    protected CommandExecutor commandExecutor;
    protected String workerId;
    protected int maxTasks;
    protected boolean usePriority;
    protected List<QueryOrderingProperty> orderingProperties;
    protected Map<String, TopicFetchInstruction> instructions;
    protected TopicFetchInstruction currentInstruction;

    public ExternalTaskQueryTopicBuilderImpl(CommandExecutor commandExecutor, String workerId, int maxTasks, boolean usePriority, List<QueryOrderingProperty> orderingProperties, Map<String, TopicFetchInstruction> instructions, TopicFetchInstruction currentInstruction) {
        this.commandExecutor = commandExecutor;
        this.workerId = workerId;
        this.maxTasks = maxTasks;
        this.usePriority = usePriority;
        this.orderingProperties = orderingProperties;
        this.instructions = instructions;
        this.currentInstruction = currentInstruction;
    }

    public ExternalTaskQueryTopicBuilderImpl(CommandExecutor commandExecutor, String workerId, int maxTasks, boolean usePriority, List<QueryOrderingProperty> orderingProperties) {
        this(commandExecutor, workerId, maxTasks, usePriority, orderingProperties, new HashMap<String, TopicFetchInstruction>(), null);
    }

    public ExternalTaskQueryTopicBuilderImpl(CommandExecutor commandExecutor, String workerId, int maxTasks, boolean usePriority) {
        this(commandExecutor, workerId, maxTasks, usePriority, new ArrayList<QueryOrderingProperty>(), new HashMap<String, TopicFetchInstruction>(), null);
    }

    public ExternalTaskQueryTopicBuilderImpl(ExternalTaskQueryTopicBuilderImpl builder) {
        this(builder.commandExecutor, builder.workerId, builder.maxTasks, builder.usePriority, builder.orderingProperties, builder.instructions, builder.currentInstruction);
    }

    @Override
    public List<LockedExternalTask> execute() {
        this.submitCurrentInstruction();
        return this.commandExecutor.execute(new FetchExternalTasksCmd(this.workerId, this.maxTasks, this.instructions, this.usePriority, this.orderingProperties));
    }

    @Override
    public ExternalTaskQueryTopicBuilder topic(String topicName, long lockDuration) {
        this.submitCurrentInstruction();
        this.currentInstruction = new TopicFetchInstruction(topicName, lockDuration);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder variables(String ... variables) {
        if (variables != null) {
            this.currentInstruction.setVariablesToFetch(new ArrayList<String>(Arrays.asList(variables)));
        }
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder variables(List<String> variables) {
        this.currentInstruction.setVariablesToFetch(variables);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder processInstanceVariableEquals(Map<String, Object> variables) {
        this.currentInstruction.setFilterVariables(variables);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder processInstanceVariableEquals(String name, Object value) {
        this.currentInstruction.addFilterVariable(name, value);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder businessKey(String businessKey) {
        this.currentInstruction.setBusinessKey(businessKey);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder processDefinitionId(String processDefinitionId) {
        this.currentInstruction.setProcessDefinitionId(processDefinitionId);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder processDefinitionIdIn(String ... processDefinitionIds) {
        this.currentInstruction.setProcessDefinitionIds(processDefinitionIds);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder processDefinitionKey(String processDefinitionKey) {
        this.currentInstruction.setProcessDefinitionKey(processDefinitionKey);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder processDefinitionKeyIn(String ... processDefinitionKeys) {
        this.currentInstruction.setProcessDefinitionKeys(processDefinitionKeys);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder processDefinitionVersionTag(String processDefinitionVersionTag) {
        this.currentInstruction.setProcessDefinitionVersionTag(processDefinitionVersionTag);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder withoutTenantId() {
        this.currentInstruction.setTenantIds(null);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder tenantIdIn(String ... tenantIds) {
        this.currentInstruction.setTenantIds(tenantIds);
        return this;
    }

    protected void submitCurrentInstruction() {
        if (this.currentInstruction != null) {
            this.instructions.put(this.currentInstruction.getTopicName(), this.currentInstruction);
        }
    }

    @Override
    public ExternalTaskQueryTopicBuilder enableCustomObjectDeserialization() {
        this.currentInstruction.setDeserializeVariables(true);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder localVariables() {
        this.currentInstruction.setLocalVariables(true);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder includeExtensionProperties() {
        this.currentInstruction.setIncludeExtensionProperties(true);
        return this;
    }
}

