/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.form.deployer;

import io.openbpm.bpm.engine.impl.AbstractDefinitionDeployer;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.core.model.Properties;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import io.openbpm.bpm.engine.impl.persistence.entity.DeploymentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.OperatonFormDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ResourceEntity;
import io.openbpm.bpm.engine.impl.util.EngineUtilLogger;
import io.openbpm.bpm.engine.impl.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import openbpmjar.impl.com.google.gson.Gson;
import openbpmjar.impl.com.google.gson.JsonObject;

public class OperatonFormDefinitionDeployer
extends AbstractDefinitionDeployer<OperatonFormDefinitionEntity> {
    protected static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    public static final String[] FORM_RESOURCE_SUFFIXES = new String[]{"form"};

    @Override
    protected String[] getResourcesSuffixes() {
        return FORM_RESOURCE_SUFFIXES;
    }

    @Override
    protected List<OperatonFormDefinitionEntity> transformDefinitions(DeploymentEntity deployment, ResourceEntity resource, Properties properties) {
        String formContent = new String(resource.getBytes(), StandardCharsets.UTF_8);
        try {
            JsonObject formJsonObject = new Gson().fromJson(formContent, JsonObject.class);
            String operatonFormDefinitionKey = JsonUtil.getString(formJsonObject, "id");
            OperatonFormDefinitionEntity definition = new OperatonFormDefinitionEntity(operatonFormDefinitionKey, deployment.getId(), resource.getName(), deployment.getTenantId());
            return Collections.singletonList(definition);
        }
        catch (Exception e) {
            if (!this.getCommandContext().getProcessEngineConfiguration().isDisableStrictOperatonFormParsing()) {
                throw LOG.exceptionDuringFormParsing(e.getMessage(), resource.getName());
            }
            return Collections.emptyList();
        }
    }

    @Override
    protected OperatonFormDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.getCommandContext().getOperatonFormDefinitionManager().findDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }

    @Override
    protected OperatonFormDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.getCommandContext().getOperatonFormDefinitionManager().findLatestDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    protected void persistDefinition(OperatonFormDefinitionEntity definition) {
        this.getCommandContext().getOperatonFormDefinitionManager().insert(definition);
    }

    @Override
    protected void addDefinitionToDeploymentCache(DeploymentCache deploymentCache, OperatonFormDefinitionEntity definition) {
        deploymentCache.addOperatonFormDefinition(definition);
    }
}

