/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.form.engine;

import io.openbpm.bpm.engine.form.FormField;
import io.openbpm.bpm.engine.form.FormFieldValidationConstraint;
import io.openbpm.bpm.engine.form.FormProperty;
import io.openbpm.bpm.engine.form.FormType;
import io.openbpm.bpm.engine.impl.form.FormFieldValidationConstraintImpl;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FormPropertyAdapter
implements FormField {
    protected FormProperty formProperty;
    protected List<FormFieldValidationConstraint> validationConstraints;

    public FormPropertyAdapter(FormProperty formProperty) {
        this.formProperty = formProperty;
        this.validationConstraints = new ArrayList<FormFieldValidationConstraint>();
        if (formProperty.isRequired()) {
            this.validationConstraints.add(new FormFieldValidationConstraintImpl("required", null));
        }
        if (!formProperty.isWritable()) {
            this.validationConstraints.add(new FormFieldValidationConstraintImpl("readonly", null));
        }
    }

    @Override
    public String getId() {
        return this.formProperty.getId();
    }

    @Override
    public String getLabel() {
        return this.formProperty.getName();
    }

    @Override
    public FormType getType() {
        return this.formProperty.getType();
    }

    @Override
    public String getTypeName() {
        return this.formProperty.getType().getName();
    }

    @Override
    public Object getDefaultValue() {
        return this.formProperty.getValue();
    }

    @Override
    public List<FormFieldValidationConstraint> getValidationConstraints() {
        return this.validationConstraints;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isBusinessKey() {
        return false;
    }

    public TypedValue getDefaultValueTyped() {
        return this.getValue();
    }

    @Override
    public TypedValue getValue() {
        return Variables.stringValue((String)this.formProperty.getValue());
    }
}

