/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.form.handler;

import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.VariableScope;
import io.openbpm.bpm.engine.impl.bpmn.parser.BpmnParse;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.context.ProcessApplicationContextUtil;
import io.openbpm.bpm.engine.impl.form.handler.FormHandler;
import io.openbpm.bpm.engine.impl.form.handler.SubmitFormVariablesInvocation;
import io.openbpm.bpm.engine.impl.persistence.entity.DeploymentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.util.xml.Element;
import io.openbpm.bpm.engine.variable.VariableMap;
import java.util.concurrent.Callable;

public abstract class DelegateFormHandler {
    protected String deploymentId;
    protected FormHandler formHandler;

    protected DelegateFormHandler(FormHandler formHandler, String deploymentId) {
        this.formHandler = formHandler;
        this.deploymentId = deploymentId;
    }

    public void parseConfiguration(Element activityElement, DeploymentEntity deployment, ProcessDefinitionEntity processDefinition, BpmnParse bpmnParse) {
    }

    protected <T> T performContextSwitch(Callable<T> callable) {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication(this.deploymentId);
        if (targetProcessApplication != null) {
            return (T)Context.executeWithinProcessApplication(() -> this.doCall(callable), targetProcessApplication);
        }
        return this.doCall(callable);
    }

    protected <T> T doCall(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessEngineException(e);
        }
    }

    public void submitFormVariables(VariableMap properties, VariableScope variableScope) {
        this.performContextSwitch(() -> {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new SubmitFormVariablesInvocation(this.formHandler, properties, variableScope));
            return null;
        });
    }

    public abstract FormHandler getFormHandler();
}

