/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.form.type;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.form.type.SimpleFormFieldType;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.value.BooleanValue;
import io.openbpm.bpm.engine.variable.value.TypedValue;

public class BooleanFormType
extends SimpleFormFieldType {
    public static final String TYPE_NAME = "boolean";

    @Override
    public String getName() {
        return TYPE_NAME;
    }

    @Override
    public TypedValue convertValue(TypedValue propertyValue) {
        if (propertyValue instanceof BooleanValue) {
            return propertyValue;
        }
        Object value = propertyValue.getValue();
        if (value == null) {
            return Variables.booleanValue(null, (boolean)propertyValue.isTransient());
        }
        if (value instanceof Boolean || value instanceof String) {
            return Variables.booleanValue((Boolean)Boolean.valueOf(value.toString()), (boolean)propertyValue.isTransient());
        }
        throw new ProcessEngineException("Value '" + String.valueOf(value) + "' is not of type Boolean.");
    }

    @Override
    public Object convertFormValueToModelValue(Object propertyValue) {
        if (propertyValue == null || "".equals(propertyValue)) {
            return null;
        }
        return Boolean.valueOf(propertyValue.toString());
    }

    @Override
    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue == null) {
            return null;
        }
        if (Boolean.class.isAssignableFrom(modelValue.getClass()) || Boolean.TYPE.isAssignableFrom(modelValue.getClass())) {
            return modelValue.toString();
        }
        throw new ProcessEngineException("Model value is not of type boolean, but of type " + modelValue.getClass().getName());
    }
}

