/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.form.validator;

import io.openbpm.bpm.engine.impl.form.validator.FormFieldConfigurationException;
import io.openbpm.bpm.engine.impl.form.validator.FormFieldValidationException;
import io.openbpm.bpm.engine.impl.form.validator.FormFieldValidator;
import io.openbpm.bpm.engine.impl.form.validator.FormFieldValidatorContext;

public abstract class AbstractNumericValidator
implements FormFieldValidator {
    @Override
    public boolean validate(Object submittedValue, FormFieldValidatorContext validatorContext) {
        if (submittedValue == null) {
            return this.isNullValid();
        }
        String configurationString = validatorContext.getConfiguration();
        if (submittedValue instanceof Double) {
            Double doubleValue = (Double)submittedValue;
            Double configuration = null;
            try {
                configuration = Double.parseDouble(configurationString);
            }
            catch (NumberFormatException e) {
                throw new FormFieldConfigurationException(configurationString, "Cannot validate Double value " + String.valueOf(submittedValue) + ": configuration " + configurationString + " cannot be parsed as Double.");
            }
            return this.validate(doubleValue, configuration);
        }
        if (submittedValue instanceof Float) {
            Float floatValue = (Float)submittedValue;
            Float configuration = null;
            try {
                configuration = Float.valueOf(Float.parseFloat(configurationString));
            }
            catch (NumberFormatException e) {
                throw new FormFieldConfigurationException(configurationString, "Cannot validate Float value " + String.valueOf(submittedValue) + ": configuration " + configurationString + " cannot be parsed as Float.");
            }
            return this.validate(floatValue, configuration);
        }
        if (submittedValue instanceof Long) {
            Long longValue = (Long)submittedValue;
            Long configuration = null;
            try {
                configuration = Long.parseLong(configurationString);
            }
            catch (NumberFormatException e) {
                throw new FormFieldConfigurationException(configurationString, "Cannot validate Long value " + String.valueOf(submittedValue) + ": configuration " + configurationString + " cannot be parsed as Long.");
            }
            return this.validate(longValue, configuration);
        }
        if (submittedValue instanceof Integer) {
            Integer integerValue = (Integer)submittedValue;
            Integer configuration = null;
            try {
                configuration = Integer.parseInt(configurationString);
            }
            catch (NumberFormatException e) {
                throw new FormFieldConfigurationException(configurationString, "Cannot validate Integer value " + String.valueOf(submittedValue) + ": configuration " + configurationString + " cannot be parsed as Integer.");
            }
            return this.validate(integerValue, configuration);
        }
        if (submittedValue instanceof Short) {
            Short shortValue = (Short)submittedValue;
            Short configuration = null;
            try {
                configuration = Short.parseShort(configurationString);
            }
            catch (NumberFormatException e) {
                throw new FormFieldConfigurationException(configurationString, "Cannot validate Short value " + String.valueOf(submittedValue) + ": configuration " + configurationString + " cannot be parsed as Short.");
            }
            return this.validate(shortValue, configuration);
        }
        throw new FormFieldValidationException((Object)("Numeric validator " + this.getClass().getSimpleName() + " cannot be used on non-numeric value " + String.valueOf(submittedValue)));
    }

    protected boolean isNullValid() {
        return true;
    }

    protected abstract boolean validate(Integer var1, Integer var2);

    protected abstract boolean validate(Long var1, Long var2);

    protected abstract boolean validate(Double var1, Double var2);

    protected abstract boolean validate(Float var1, Float var2);

    protected abstract boolean validate(Short var1, Short var2);
}

