/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.form.validator;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.bpmn.parser.BpmnParse;
import io.openbpm.bpm.engine.impl.el.Expression;
import io.openbpm.bpm.engine.impl.el.ExpressionManager;
import io.openbpm.bpm.engine.impl.form.validator.DelegateFormFieldValidator;
import io.openbpm.bpm.engine.impl.form.validator.FormFieldValidator;
import io.openbpm.bpm.engine.impl.util.StringUtil;
import io.openbpm.bpm.engine.impl.util.xml.Element;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class FormValidators {
    protected Map<String, Class<? extends FormFieldValidator>> validators = new HashMap<String, Class<? extends FormFieldValidator>>();

    /*
     * Enabled aggressive block sorting
     */
    public FormFieldValidator createValidator(Element constraint, BpmnParse bpmnParse, ExpressionManager expressionManager) {
        String name = constraint.attribute("name");
        String config = constraint.attribute("config");
        if ("validator".equals(name)) {
            if (config != null && !config.isEmpty()) {
                if (!StringUtil.isExpression(config)) return new DelegateFormFieldValidator(config);
                Expression validatorExpression = expressionManager.createExpression(config);
                return new DelegateFormFieldValidator(validatorExpression);
            }
            bpmnParse.addError("validator configuration needs to provide either a fully qualified classname or an expression resolving to a custom FormFieldValidator implementation.", constraint);
            return null;
        }
        Class<? extends FormFieldValidator> validator = this.validators.get(name);
        if (validator != null) {
            return this.createValidatorInstance(validator);
        }
        bpmnParse.addError("Cannot find validator implementation for name '" + name + "'.", constraint);
        return null;
    }

    protected FormFieldValidator createValidatorInstance(Class<? extends FormFieldValidator> validator) {
        try {
            return validator.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ProcessEngineException("Could not instantiate validator", e);
        }
    }

    public void addValidator(String name, Class<? extends FormFieldValidator> validatorType) {
        this.validators.put(name, validatorType);
    }

    public Map<String, Class<? extends FormFieldValidator>> getValidators() {
        return this.validators;
    }
}

