/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.history.event;

import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.history.event.HistoryEvent;
import io.openbpm.bpm.engine.impl.history.handler.HistoryEventHandler;
import io.openbpm.bpm.engine.impl.history.producer.HistoryEventProducer;
import java.util.Collections;
import java.util.List;

public final class HistoryEventProcessor {
    public static void processHistoryEvents(HistoryEventCreator creator) {
        HistoryEventProducer historyEventProducer = Context.getProcessEngineConfiguration().getHistoryEventProducer();
        HistoryEventHandler historyEventHandler = Context.getProcessEngineConfiguration().getHistoryEventHandler();
        HistoryEvent singleEvent = creator.createHistoryEvent(historyEventProducer);
        if (singleEvent != null) {
            historyEventHandler.handleEvent(singleEvent);
            creator.postHandleSingleHistoryEventCreated(singleEvent);
        }
        List<HistoryEvent> eventList = creator.createHistoryEvents(historyEventProducer);
        historyEventHandler.handleEvents(eventList);
    }

    private HistoryEventProcessor() {
    }

    public static class HistoryEventCreator {
        public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
            return null;
        }

        public List<HistoryEvent> createHistoryEvents(HistoryEventProducer producer) {
            return Collections.emptyList();
        }

        public void postHandleSingleHistoryEventCreated(HistoryEvent event) {
        }
    }
}

