/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.history.handler;

import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.entitymanager.DbEntityManager;
import io.openbpm.bpm.engine.impl.history.event.HistoricDecisionEvaluationEvent;
import io.openbpm.bpm.engine.impl.history.event.HistoricScopeInstanceEvent;
import io.openbpm.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import io.openbpm.bpm.engine.impl.history.event.HistoryEvent;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventTypes;
import io.openbpm.bpm.engine.impl.history.handler.HistoryEventHandler;
import io.openbpm.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import io.openbpm.bpm.engine.repository.ResourceTypes;
import java.util.List;

public class DbHistoryEventHandler
implements HistoryEventHandler {
    @Override
    public void handleEvent(HistoryEvent historyEvent) {
        if (historyEvent instanceof HistoricVariableUpdateEventEntity) {
            HistoricVariableUpdateEventEntity historicVariableUpdateEventEntity = (HistoricVariableUpdateEventEntity)historyEvent;
            this.insertHistoricVariableUpdateEntity(historicVariableUpdateEventEntity);
        } else if (historyEvent instanceof HistoricDecisionEvaluationEvent) {
            HistoricDecisionEvaluationEvent historicDecisionEvaluationEvent = (HistoricDecisionEvaluationEvent)historyEvent;
            this.insertHistoricDecisionEvaluationEvent(historicDecisionEvaluationEvent);
        } else {
            this.insertOrUpdate(historyEvent);
        }
    }

    @Override
    public void handleEvents(List<HistoryEvent> historyEvents) {
        for (HistoryEvent historyEvent : historyEvents) {
            this.handleEvent(historyEvent);
        }
    }

    protected void insertOrUpdate(HistoryEvent historyEvent) {
        DbEntityManager dbEntityManager = this.getDbEntityManager();
        if (this.isInitialEvent(historyEvent)) {
            dbEntityManager.insert(historyEvent);
        } else if (dbEntityManager.getCachedEntity(historyEvent.getClass(), historyEvent.getId()) == null) {
            if (historyEvent instanceof HistoricScopeInstanceEvent) {
                HistoricScopeInstanceEvent historicScopeInstanceEvent = (HistoricScopeInstanceEvent)historyEvent;
                HistoricScopeInstanceEvent existingEvent = (HistoricScopeInstanceEvent)dbEntityManager.selectById(historyEvent.getClass(), historyEvent.getId());
                if (existingEvent != null) {
                    historicScopeInstanceEvent.setStartTime(existingEvent.getStartTime());
                }
            }
            if (historyEvent.getId() != null) {
                dbEntityManager.merge(historyEvent);
            }
        }
    }

    protected void insertHistoricVariableUpdateEntity(HistoricVariableUpdateEventEntity historyEvent) {
        HistoricVariableInstanceEntity historicVariableInstanceEntity;
        DbEntityManager dbEntityManager = this.getDbEntityManager();
        if (this.shouldWriteHistoricDetail(historyEvent)) {
            byte[] byteValue = historyEvent.getByteValue();
            if (byteValue != null) {
                ByteArrayEntity byteArrayEntity = new ByteArrayEntity(historyEvent.getVariableName(), byteValue, ResourceTypes.HISTORY);
                byteArrayEntity.setRootProcessInstanceId(historyEvent.getRootProcessInstanceId());
                byteArrayEntity.setRemovalTime(historyEvent.getRemovalTime());
                Context.getCommandContext().getByteArrayManager().insertByteArray(byteArrayEntity);
                historyEvent.setByteArrayId(byteArrayEntity.getId());
            }
            dbEntityManager.insert(historyEvent);
        }
        if (historyEvent.isEventOfType(HistoryEventTypes.VARIABLE_INSTANCE_CREATE)) {
            HistoricVariableInstanceEntity persistentObject = new HistoricVariableInstanceEntity(historyEvent);
            dbEntityManager.insert(persistentObject);
        } else if (historyEvent.isEventOfType(HistoryEventTypes.VARIABLE_INSTANCE_UPDATE) || historyEvent.isEventOfType(HistoryEventTypes.VARIABLE_INSTANCE_MIGRATE)) {
            historicVariableInstanceEntity = dbEntityManager.selectById(HistoricVariableInstanceEntity.class, historyEvent.getVariableInstanceId());
            if (historicVariableInstanceEntity != null) {
                historicVariableInstanceEntity.updateFromEvent(historyEvent);
                historicVariableInstanceEntity.setState("CREATED");
            } else {
                HistoricVariableInstanceEntity persistentObject = new HistoricVariableInstanceEntity(historyEvent);
                dbEntityManager.insert(persistentObject);
            }
        } else if (historyEvent.isEventOfType(HistoryEventTypes.VARIABLE_INSTANCE_DELETE) && (historicVariableInstanceEntity = dbEntityManager.selectById(HistoricVariableInstanceEntity.class, historyEvent.getVariableInstanceId())) != null) {
            historicVariableInstanceEntity.setState("DELETED");
        }
    }

    protected boolean shouldWriteHistoricDetail(HistoricVariableUpdateEventEntity historyEvent) {
        return Context.getProcessEngineConfiguration().getHistoryLevel().isHistoryEventProduced(HistoryEventTypes.VARIABLE_INSTANCE_UPDATE_DETAIL, historyEvent) && !historyEvent.isEventOfType(HistoryEventTypes.VARIABLE_INSTANCE_MIGRATE);
    }

    protected void insertHistoricDecisionEvaluationEvent(HistoricDecisionEvaluationEvent event) {
        Context.getCommandContext().getHistoricDecisionInstanceManager().insertHistoricDecisionInstances(event);
    }

    protected boolean isInitialEvent(HistoryEvent historyEvent) {
        return historyEvent.getEventType() == null || historyEvent.isEventOfType(HistoryEventTypes.ACTIVITY_INSTANCE_START) || historyEvent.isEventOfType(HistoryEventTypes.PROCESS_INSTANCE_START) || historyEvent.isEventOfType(HistoryEventTypes.TASK_INSTANCE_CREATE) || historyEvent.isEventOfType(HistoryEventTypes.FORM_PROPERTY_UPDATE) || historyEvent.isEventOfType(HistoryEventTypes.INCIDENT_CREATE) || historyEvent.isEventOfType(HistoryEventTypes.CASE_INSTANCE_CREATE) || historyEvent.isEventOfType(HistoryEventTypes.DMN_DECISION_EVALUATE) || historyEvent.isEventOfType(HistoryEventTypes.BATCH_START) || historyEvent.isEventOfType(HistoryEventTypes.IDENTITY_LINK_ADD) || historyEvent.isEventOfType(HistoryEventTypes.IDENTITY_LINK_DELETE);
    }

    protected DbEntityManager getDbEntityManager() {
        return Context.getCommandContext().getDbEntityManager();
    }
}

