/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.history.parser;

import io.openbpm.bpm.dmn.engine.DmnDecision;
import io.openbpm.bpm.dmn.engine.delegate.DmnDecisionEvaluationEvent;
import io.openbpm.bpm.dmn.engine.delegate.DmnDecisionEvaluationListener;
import io.openbpm.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.context.CoreExecutionContext;
import io.openbpm.bpm.engine.impl.core.instance.CoreExecution;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.history.event.HistoryEvent;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventTypes;
import io.openbpm.bpm.engine.impl.history.producer.DmnHistoryEventProducer;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.repository.DecisionDefinition;

public class HistoryDecisionEvaluationListener
implements DmnDecisionEvaluationListener {
    protected DmnHistoryEventProducer eventProducer;
    protected HistoryLevel historyLevel;

    public HistoryDecisionEvaluationListener(DmnHistoryEventProducer historyEventProducer) {
        this.eventProducer = historyEventProducer;
    }

    public void notify(DmnDecisionEvaluationEvent evaluationEvent) {
        HistoryEvent historyEvent = this.createHistoryEvent(evaluationEvent);
        if (historyEvent != null) {
            Context.getProcessEngineConfiguration().getHistoryEventHandler().handleEvent(historyEvent);
        }
    }

    protected HistoryEvent createHistoryEvent(DmnDecisionEvaluationEvent evaluationEvent) {
        DmnDecision decisionTable;
        if (this.historyLevel == null) {
            this.historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        }
        if (this.isDeployedDecisionTable(decisionTable = evaluationEvent.getDecisionResult().getDecision()) && this.historyLevel.isHistoryEventProduced(HistoryEventTypes.DMN_DECISION_EVALUATE, decisionTable)) {
            CoreExecutionContext<? extends CoreExecution> executionContext = Context.getCoreExecutionContext();
            if (executionContext != null) {
                CoreExecution coreExecution = executionContext.getExecution();
                if (coreExecution instanceof ExecutionEntity) {
                    ExecutionEntity execution = (ExecutionEntity)coreExecution;
                    return this.eventProducer.createDecisionEvaluatedEvt(execution, evaluationEvent);
                }
                if (coreExecution instanceof CaseExecutionEntity) {
                    CaseExecutionEntity caseExecution = (CaseExecutionEntity)coreExecution;
                    return this.eventProducer.createDecisionEvaluatedEvt(caseExecution, evaluationEvent);
                }
            }
            return this.eventProducer.createDecisionEvaluatedEvt(evaluationEvent);
        }
        return null;
    }

    protected boolean isDeployedDecisionTable(DmnDecision decision) {
        if (decision instanceof DecisionDefinition) {
            DecisionDefinition decisionDefinition = (DecisionDefinition)decision;
            return decisionDefinition.getId() != null;
        }
        return false;
    }
}

