/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.history.parser;

import io.openbpm.bpm.engine.delegate.ExecutionListener;
import io.openbpm.bpm.engine.delegate.TaskListener;
import io.openbpm.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventTypes;
import io.openbpm.bpm.engine.impl.history.parser.ActivityInstanceEndListener;
import io.openbpm.bpm.engine.impl.history.parser.ActivityInstanceStartListener;
import io.openbpm.bpm.engine.impl.history.parser.ActivityInstanceUpdateListener;
import io.openbpm.bpm.engine.impl.history.parser.ProcessInstanceEndListener;
import io.openbpm.bpm.engine.impl.history.parser.ProcessInstanceStartListener;
import io.openbpm.bpm.engine.impl.history.producer.HistoryEventProducer;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.impl.task.TaskDefinition;
import io.openbpm.bpm.engine.impl.util.xml.Element;

public class HistoryParseListener
implements BpmnParseListener {
    protected ExecutionListener processInstanceStartListener;
    protected ExecutionListener processInstanceEndListener;
    protected ExecutionListener activityInstanceStartListener;
    protected ExecutionListener activityInstanceEndListener;
    protected TaskListener userTaskAssignmentHandler;
    protected TaskListener userTaskIdHandler;
    protected HistoryLevel historyLevel;

    public HistoryParseListener(HistoryEventProducer historyEventProducer) {
        this.initExecutionListeners(historyEventProducer);
    }

    protected void initExecutionListeners(HistoryEventProducer historyEventProducer) {
        this.processInstanceStartListener = new ProcessInstanceStartListener(historyEventProducer);
        this.processInstanceEndListener = new ProcessInstanceEndListener(historyEventProducer);
        this.activityInstanceStartListener = new ActivityInstanceStartListener(historyEventProducer);
        this.activityInstanceEndListener = new ActivityInstanceEndListener(historyEventProducer);
        this.userTaskIdHandler = this.userTaskAssignmentHandler = new ActivityInstanceUpdateListener(historyEventProducer);
    }

    @Override
    public void parseProcess(Element processElement, ProcessDefinitionEntity processDefinition) {
        this.ensureHistoryLevelInitialized();
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_END, null)) {
            processDefinition.addBuiltInListener("end", this.processInstanceEndListener);
        }
    }

    @Override
    public void parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseCallActivity(Element callActivityElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseManualTask(Element manualTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseReceiveTask(Element receiveTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseScriptTask(Element scriptTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseTask(Element taskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.ensureHistoryLevelInitialized();
        this.addActivityHandlers(activity);
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.TASK_INSTANCE_CREATE, null)) {
            TaskDefinition taskDefinition = ((UserTaskActivityBehavior)activity.getActivityBehavior()).getTaskDefinition();
            taskDefinition.addBuiltInTaskListener("assignment", this.userTaskAssignmentHandler);
            taskDefinition.addBuiltInTaskListener("create", this.userTaskIdHandler);
        }
    }

    @Override
    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseSubProcess(Element subProcessElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseStartEvent(Element startEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseParallelGateway(Element parallelGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseEventBasedGateway(Element eventBasedGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseMultiInstanceLoopCharacteristics(Element activityElement, Element multiInstanceLoopCharacteristicsElement, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseIntermediateSignalCatchEventDefinition(Element signalEventDefinition, ActivityImpl signalActivity) {
    }

    @Override
    public void parseTransaction(Element transactionElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        if (!"intermediateLinkCatch".equals(activity.getProperty("type"))) {
            this.addActivityHandlers(activity);
        }
    }

    @Override
    public void parseBoundaryEvent(Element boundaryEventElement, ScopeImpl scopeElement, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    protected void addActivityHandlers(ActivityImpl activity) {
        this.ensureHistoryLevelInitialized();
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.ACTIVITY_INSTANCE_START, null)) {
            activity.addBuiltInListener("start", this.activityInstanceStartListener, 0);
        }
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.ACTIVITY_INSTANCE_END, null)) {
            activity.addBuiltInListener("end", this.activityInstanceEndListener);
        }
    }

    protected void ensureHistoryLevelInitialized() {
        if (this.historyLevel == null) {
            this.historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        }
    }
}

