/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.identity;

import io.openbpm.bpm.engine.identity.PasswordPolicyRule;
import java.util.HashMap;
import java.util.Map;

public class PasswordPolicyDigitRuleImpl
implements PasswordPolicyRule {
    public static final String PLACEHOLDER = "PASSWORD_POLICY_DIGIT";
    protected int minDigit;

    public PasswordPolicyDigitRuleImpl(int minDigit) {
        this.minDigit = minDigit;
    }

    @Override
    public String getPlaceholder() {
        return PLACEHOLDER;
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("minDigit", "" + this.minDigit);
        return parameter;
    }

    @Override
    public boolean execute(String password) {
        int digitCount = 0;
        char[] cArray = password.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isDigit(c.charValue())) {
                ++digitCount;
            }
            if (digitCount < this.minDigit) continue;
            return true;
        }
        return false;
    }
}

