/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.identity.db;

import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.authorization.Resource;
import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.identity.Group;
import io.openbpm.bpm.engine.identity.GroupQuery;
import io.openbpm.bpm.engine.identity.NativeUserQuery;
import io.openbpm.bpm.engine.identity.Tenant;
import io.openbpm.bpm.engine.identity.TenantQuery;
import io.openbpm.bpm.engine.identity.User;
import io.openbpm.bpm.engine.identity.UserQuery;
import io.openbpm.bpm.engine.impl.AbstractQuery;
import io.openbpm.bpm.engine.impl.NativeUserQueryImpl;
import io.openbpm.bpm.engine.impl.UserQueryImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import io.openbpm.bpm.engine.impl.identity.db.DbGroupQueryImpl;
import io.openbpm.bpm.engine.impl.identity.db.DbTenantQueryImpl;
import io.openbpm.bpm.engine.impl.identity.db.DbUserQueryImpl;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.AbstractManager;
import io.openbpm.bpm.engine.impl.persistence.entity.GroupEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TenantEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.UserEntity;
import io.openbpm.bpm.engine.impl.util.EncryptionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbReadOnlyIdentityServiceProvider
extends AbstractManager
implements ReadOnlyIdentityProvider {
    @Override
    public UserEntity findUserById(String userId) {
        this.checkAuthorization(Permissions.READ, Resources.USER, userId);
        return this.getDbEntityManager().selectById(UserEntity.class, userId);
    }

    @Override
    public UserQuery createUserQuery() {
        return new DbUserQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    @Override
    public UserQueryImpl createUserQuery(CommandContext commandContext) {
        return new DbUserQueryImpl();
    }

    @Override
    public NativeUserQuery createNativeUserQuery() {
        return new NativeUserQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public long findUserCountByQueryCriteria(DbUserQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.USER);
        return (Long)this.getDbEntityManager().selectOne("selectUserCountByQueryCriteria", query);
    }

    public List<User> findUserByQueryCriteria(DbUserQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.USER);
        return this.getDbEntityManager().selectList("selectUserByQueryCriteria", query);
    }

    public List<User> findUserByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectUserByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findUserCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectUserCountByNativeQuery", parameterMap);
    }

    @Override
    public boolean checkPassword(String userId, String password) {
        UserEntity user = this.findUserById(userId);
        return user != null && password != null && this.matchPassword(password, user);
    }

    protected boolean matchPassword(String password, UserEntity user) {
        String saltedPassword = EncryptionUtil.saltPassword(password, user.getSalt());
        return Context.getProcessEngineConfiguration().getPasswordManager().check(saltedPassword, user.getPassword());
    }

    @Override
    public GroupEntity findGroupById(String groupId) {
        this.checkAuthorization(Permissions.READ, Resources.GROUP, groupId);
        return this.getDbEntityManager().selectById(GroupEntity.class, groupId);
    }

    @Override
    public GroupQuery createGroupQuery() {
        return new DbGroupQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    @Override
    public GroupQuery createGroupQuery(CommandContext commandContext) {
        return new DbGroupQueryImpl();
    }

    public long findGroupCountByQueryCriteria(DbGroupQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.GROUP);
        return (Long)this.getDbEntityManager().selectOne("selectGroupCountByQueryCriteria", query);
    }

    public List<Group> findGroupByQueryCriteria(DbGroupQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.GROUP);
        return this.getDbEntityManager().selectList("selectGroupByQueryCriteria", query);
    }

    @Override
    public TenantEntity findTenantById(String tenantId) {
        this.checkAuthorization(Permissions.READ, Resources.TENANT, tenantId);
        return this.getDbEntityManager().selectById(TenantEntity.class, tenantId);
    }

    @Override
    public TenantQuery createTenantQuery() {
        return new DbTenantQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    @Override
    public TenantQuery createTenantQuery(CommandContext commandContext) {
        return new DbTenantQueryImpl();
    }

    public long findTenantCountByQueryCriteria(DbTenantQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.TENANT);
        return (Long)this.getDbEntityManager().selectOne("selectTenantCountByQueryCriteria", query);
    }

    public List<Tenant> findTenantByQueryCriteria(DbTenantQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.TENANT);
        return this.getDbEntityManager().selectList("selectTenantByQueryCriteria", query);
    }

    protected boolean existsMembership(String userId, String groupId) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("userId", userId);
        key.put("groupId", groupId);
        return (Long)this.getDbEntityManager().selectOne("selectMembershipCount", key) > 0L;
    }

    protected boolean existsTenantMembership(String tenantId, String userId, String groupId) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("tenantId", tenantId);
        if (userId != null) {
            key.put("userId", userId);
        }
        if (groupId != null) {
            key.put("groupId", groupId);
        }
        return (Long)this.getDbEntityManager().selectOne("selectTenantMembershipCount", key) > 0L;
    }

    protected void configureQuery(AbstractQuery query, Resource resource) {
        Context.getCommandContext().getAuthorizationManager().configureQuery(query, resource);
    }

    @Override
    protected void checkAuthorization(Permission permission, Resource resource, String resourceId) {
        Context.getCommandContext().getAuthorizationManager().checkAuthorization(permission, resource, resourceId);
    }
}

