/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.incident;

import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.incident.DefaultIncidentHandler;
import io.openbpm.bpm.engine.impl.incident.IncidentContext;
import io.openbpm.bpm.engine.impl.incident.IncidentHandler;
import io.openbpm.bpm.engine.runtime.Incident;

public final class IncidentHandling {
    public static Incident createIncident(String incidentType, IncidentContext context, String message) {
        IncidentHandler handler = Context.getProcessEngineConfiguration().getIncidentHandler(incidentType);
        if (handler == null) {
            handler = new DefaultIncidentHandler(incidentType);
        }
        return handler.handleIncident(context, message);
    }

    public static void removeIncidents(String incidentType, IncidentContext context, boolean incidentsResolved) {
        IncidentHandler handler = Context.getProcessEngineConfiguration().getIncidentHandler(incidentType);
        if (handler == null) {
            handler = new DefaultIncidentHandler(incidentType);
        }
        if (incidentsResolved) {
            handler.resolveIncident(context);
        } else {
            handler.deleteIncident(context);
        }
    }

    private IncidentHandling() {
    }
}

